/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.config;

import cn.hutool.core.util.StrUtil;
import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.efficient.ykz.api.YkzUserCenterHandleService;
import com.efficient.ykz.exception.YkzException;
import com.efficient.ykz.properties.YkzApi;
import com.efficient.ykz.properties.YkzProperties;
import com.efficient.ykz.service.YkzUserCenterHandleDefaultService;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={YkzProperties.class})
@MapperScan(basePackages={"com.efficient.ykz.dao"})
public class YkzConfig {
    private static final Logger log = LoggerFactory.getLogger(YkzConfig.class);
    private final AtomicReference<ExecutableClient> executableClientRef = new AtomicReference();
    @Autowired
    private YkzProperties ykzProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableClient getExecutableClient() {
        ExecutableClient currentClient = this.executableClientRef.get();
        if (Objects.isNull(currentClient)) {
            YkzConfig ykzConfig = this;
            synchronized (ykzConfig) {
                currentClient = this.executableClientRef.get();
                if (Objects.isNull(currentClient)) {
                    currentClient = this.init();
                    this.executableClientRef.set(currentClient);
                }
            }
        }
        return currentClient;
    }

    public ExecutableClient init() {
        log.info("\u521d\u59cb\u5316YKZ  executableClient");
        ExecutableClient executableClient = ExecutableClient.getInstance();
        YkzApi ykzApi = this.ykzProperties.getYkzApi();
        executableClient.setDomainName(ykzApi.getDomainName());
        executableClient.setProtocal(ykzApi.getProtocal());
        String appkey = ykzApi.getAppkey();
        if (StrUtil.isBlank((CharSequence)appkey)) {
            throw new YkzException("\u8bf7\u68c0\u67e5YKZ \u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        executableClient.setAccessKey(appkey);
        String appsecret = ykzApi.getAppsecret();
        if (StrUtil.isBlank((CharSequence)appsecret)) {
            throw new YkzException("\u8bf7\u68c0\u67e5YKZ \u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        executableClient.setSecretKey(appsecret);
        executableClient.init();
        return executableClient;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"com.efficient.ykz.userCenter.handle"}, havingValue="default", matchIfMissing=true)
    public YkzUserCenterHandleService defaultHandle() {
        return new YkzUserCenterHandleDefaultService();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"com.efficient.ykz.userCenter.handle"}, havingValue="custom", matchIfMissing=true)
    public YkzUserCenterHandleService customHandle() throws Exception {
        String handleClassName = this.ykzProperties.getUserCenter().getHandleClassName();
        if (StrUtil.isBlank((CharSequence)handleClassName)) {
            throw new YkzException("\u5f53com.efficient.ykz.userCenter.handle\u914d\u7f6e\u4e3acustom\uff0chandleClassName \u5fc5\u586b");
        }
        Class<?> aClass = Class.forName(handleClassName);
        Object object = aClass.newInstance();
        if (object instanceof YkzUserCenterHandleService) {
            return (YkzUserCenterHandleService)object;
        }
        throw new YkzException("com.efficient.ykz.userCenter.handleClassName \u5fc5\u987b\u5b9e\u73b0YkzUserCenterHandleService");
    }
}

