/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.service;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.dcqc.uc.oauth.sdk.util.JwtHelper;
import com.dcqc.uc.oauth.sdk.util.SM2ToolUtil;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.CollUtil;
import com.efficient.common.util.IdUtil;
import com.efficient.common.util.JackSonUtil;
import com.efficient.ykz.api.YkzOrgService;
import com.efficient.ykz.api.YkzUserCenterService;
import com.efficient.ykz.api.YkzUserPostService;
import com.efficient.ykz.api.YkzUserService;
import com.efficient.ykz.exception.YkzException;
import com.efficient.ykz.model.dto.YkzParam;
import com.efficient.ykz.model.vo.YkzAccessToken;
import com.efficient.ykz.model.vo.YkzLabel;
import com.efficient.ykz.model.vo.YkzOrg;
import com.efficient.ykz.model.vo.YkzOrgPage;
import com.efficient.ykz.model.vo.YkzResult;
import com.efficient.ykz.model.vo.YkzUser;
import com.efficient.ykz.model.vo.YkzUserPost;
import com.efficient.ykz.properties.YkzProperties;
import com.efficient.ykz.util.YkzUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class YkzUserCenterServiceImpl
implements YkzUserCenterService {
    private static final Logger log = LoggerFactory.getLogger(YkzUserCenterServiceImpl.class);
    private static final TransmittableThreadLocal<Result> YKZ_ERROR_MSG = new TransmittableThreadLocal();
    public static Integer maxPageSize = 100;
    private static Date expiresInDate = null;
    private static String accessToken = null;
    @Resource
    JwtHelper jwtHelper;
    @Autowired
    private YkzProperties ykzProperties;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public Result<YkzOrg> orgByCode(String orgCode) {
        JSONObject jsonObject = JSONUtil.createObj().set("organizationCode", (Object)orgCode);
        YkzOrg ykzOrg = this.sendRequestOne(this.ykzProperties.getUserCenter().getOrgByCode(), true, jsonObject, YkzOrg.class);
        if (Objects.isNull(ykzOrg)) {
            if (this.ykzProperties.getUserCenter().isDb()) {
                YkzOrgService ykzOrgService = (YkzOrgService)this.applicationContext.getBean(YkzOrgService.class);
                ykzOrgService.saveErrorMsg(JackSonUtil.toJson((Object)YKZ_ERROR_MSG.get()));
            }
            return (Result)YKZ_ERROR_MSG.get();
        }
        if (this.ykzProperties.getUserCenter().isDb()) {
            YkzOrgService ykzOrgService = (YkzOrgService)this.applicationContext.getBean(YkzOrgService.class);
            ykzOrgService.saveOne(ykzOrg);
        }
        return Result.ok((Object)ykzOrg);
    }

    @Override
    public Result<List<YkzOrg>> orgByCodeList(List<String> orgCodeList) {
        YkzOrgService ykzOrgService;
        if (cn.hutool.core.collection.CollUtil.isEmpty(orgCodeList)) {
            return Result.ok();
        }
        List splitList = CollUtil.splitList(orgCodeList, (int)maxPageSize);
        ArrayList<YkzOrg> resultList = new ArrayList<YkzOrg>();
        for (List list : splitList) {
            JSONObject jsonObject = JSONUtil.createObj().set("organizationCodes", (Object)list);
            List<YkzOrg> ykzOrgList = this.sendRequestList(this.ykzProperties.getUserCenter().getOrgByCodeList(), true, jsonObject, YkzOrg.class);
            if (!cn.hutool.core.collection.CollUtil.isNotEmpty(ykzOrgList)) continue;
            resultList.addAll(ykzOrgList);
        }
        log.info("\u6279\u91cf\u83b7\u53d6\u673a\u6784\u4fe1\u606f\u6761\u6570\uff1a{}", (Object)resultList.size());
        if (cn.hutool.core.collection.CollUtil.isEmpty(resultList)) {
            if (this.ykzProperties.getUserCenter().isDb()) {
                ykzOrgService = (YkzOrgService)this.applicationContext.getBean(YkzOrgService.class);
                ykzOrgService.saveErrorMsg(JackSonUtil.toJson((Object)YKZ_ERROR_MSG.get()));
            }
            return (Result)YKZ_ERROR_MSG.get();
        }
        if (this.ykzProperties.getUserCenter().isDb()) {
            ykzOrgService = (YkzOrgService)this.applicationContext.getBean(YkzOrgService.class);
            ykzOrgService.saveBatchDb(resultList);
        }
        return Result.ok(resultList);
    }

    @Override
    public Result<List<YkzOrg>> orgByParentCode(String orgCode, Integer pageNum, Integer pageSize, boolean includeTop, boolean flattenTree) {
        Result<YkzOrg> result;
        TimeInterval timeInterval = DateUtil.timer();
        List<YkzOrg> resultList = this.childOrg(orgCode, pageNum, pageSize);
        log.info("\u67e5\u8be2\u9876\u7ea7\u8282\u70b9\u6570\u636e\uff1a{}", (Object)orgCode);
        if (!StrUtil.equalsAny((CharSequence)orgCode, (CharSequence[])new CharSequence[]{"GO_1065d20ebe964b4d9da264cfe5e5d240", "575324d0-2257-4f53-8e5f-ca72d992abe9"}) && includeTop && (result = this.orgByCode(orgCode)).getCode().intValue() == ResultEnum.SUCCESS.getCode()) {
            resultList.add((YkzOrg)result.getData());
        }
        log.info("\u603b\u5171\u62c9\u53d6\u673a\u6784\u6570\u91cf\uff1a{},\u8017\u65f6\uff1a{} s", (Object)resultList.size(), (Object)(timeInterval.interval() / 1000L));
        List<YkzOrg> ykzOrgList = YkzUtil.createTree(resultList, flattenTree);
        if (cn.hutool.core.collection.CollUtil.isEmpty(resultList)) {
            if (this.ykzProperties.getUserCenter().isDb()) {
                YkzOrgService ykzOrgService = (YkzOrgService)this.applicationContext.getBean(YkzOrgService.class);
                ykzOrgService.saveErrorMsg(JackSonUtil.toJson((Object)YKZ_ERROR_MSG.get()));
            }
        } else if (this.ykzProperties.getUserCenter().isDb()) {
            YkzOrgService ykzOrgService = (YkzOrgService)this.applicationContext.getBean(YkzOrgService.class);
            ykzOrgService.saveBatchDb(resultList);
        }
        return cn.hutool.core.collection.CollUtil.isEmpty(ykzOrgList) ? Result.fail() : Result.ok(ykzOrgList);
    }

    @Override
    public YkzAccessToken getAccessToken(String appId, String appSecret) {
        if (StrUtil.isBlank((CharSequence)appId)) {
            appId = this.ykzProperties.getUserCenter().getAppId();
        }
        if (StrUtil.isBlank((CharSequence)appSecret)) {
            appSecret = this.ykzProperties.getUserCenter().getAppSecret();
        }
        if (StrUtil.isBlank((CharSequence)appId) || StrUtil.isBlank((CharSequence)appSecret)) {
            throw new YkzException("\u8bf7\u68c0\u67e5\u6e1d\u5feb\u653f\u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        Date now = new Date();
        JSONObject jsonObject = JSONUtil.createObj().set("appId", (Object)appId).set("appSecret", (Object)SM2ToolUtil.sm2Encode((BCECPublicKey)this.jwtHelper.getPublicKey(), (String)appSecret));
        YkzAccessToken userCenterAccessToken = this.sendRequestOne(this.ykzProperties.getUserCenter().getAccessTokenUrl(), false, jsonObject, YkzAccessToken.class);
        accessToken = userCenterAccessToken.getAccessToken();
        expiresInDate = DateUtil.offsetSecond((Date)now, (int)(userCenterAccessToken.getExpiresIn() - 30));
        return userCenterAccessToken;
    }

    @Override
    public YkzAccessToken getAccessToken() {
        return this.getAccessToken(null, null);
    }

    @Override
    public <M> M sendRequestOne(String url, boolean hasToken, JSONObject params, Class<M> tClass) {
        YkzResult ykzResult = this.sendRequest(url, hasToken, params);
        if (Objects.isNull(ykzResult)) {
            return null;
        }
        if (Objects.equals(Boolean.FALSE, ykzResult.getSuccess()) || Objects.isNull(ykzResult.getData())) {
            YKZ_ERROR_MSG.set((Object)Result.build((Integer)ykzResult.getStatus(), (String)ykzResult.getMessage()));
            return null;
        }
        return (M)JackSonUtil.toObject((String)JackSonUtil.toJson((Object)ykzResult.getData()), tClass);
    }

    @Override
    public YkzResult sendRequest(String url, boolean hasToken, JSONObject params) {
        HttpRequest httpRequest = HttpRequest.post((String)(this.ykzProperties.getUserCenter().getIp() + url));
        httpRequest.contentType("application/json;charset=utf-8");
        YkzParam ykzParam = YkzParam.builder().requestId(IdUtil.uuid()).data(params).build();
        httpRequest.body(JackSonUtil.toJson((Object)ykzParam));
        log.info("sendRequest \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JackSonUtil.toJson((Object)ykzParam));
        if (hasToken) {
            String token = this.setRequestHeader();
            httpRequest.header("Authorization", "Bearer " + token);
        }
        HttpResponse response = httpRequest.execute();
        log.info("{} \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)url, (Object)response.body());
        YkzResult ykzResult = (YkzResult)JackSonUtil.toObject((String)response.body(), YkzResult.class);
        return ykzResult;
    }

    @Override
    public <M> List<M> sendRequestList(String url, boolean hasToken, JSONObject params, Class<M> tClass) {
        HttpRequest httpRequest = HttpRequest.post((String)(this.ykzProperties.getUserCenter().getIp() + url));
        httpRequest.contentType("application/json;charset=utf-8");
        YkzParam ykzParam = YkzParam.builder().requestId(IdUtil.uuid()).data(params).build();
        httpRequest.body(JackSonUtil.toJson((Object)ykzParam));
        log.info("sendRequestList \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JackSonUtil.toJson((Object)ykzParam));
        if (hasToken) {
            String token = this.setRequestHeader();
            httpRequest.header("Authorization", "Bearer " + token);
        }
        HttpResponse response = httpRequest.execute();
        log.info("{} \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)url, (Object)response.body());
        YkzResult ykzResult = (YkzResult)JackSonUtil.toObject((String)response.body(), YkzResult.class);
        if (Objects.isNull(ykzResult) || Objects.equals(Boolean.FALSE, ykzResult.getSuccess()) || Objects.isNull(ykzResult.getData())) {
            if (Objects.nonNull(ykzResult)) {
                YKZ_ERROR_MSG.set((Object)Result.build((Integer)ykzResult.getStatus(), (String)ykzResult.getMessage()));
            }
            return null;
        }
        return JackSonUtil.toObjectList((String)JackSonUtil.toJson((Object)ykzResult.getData()), tClass);
    }

    @Override
    public Result<YkzUser> userByMobile(String phone) {
        JSONObject jsonObject = JSONUtil.createObj().set("mobile", (Object)phone);
        YkzUser ykzUser = this.sendRequestOne(this.ykzProperties.getUserCenter().getUserByMobile(), true, jsonObject, YkzUser.class);
        if (Objects.isNull(ykzUser)) {
            if (this.ykzProperties.getUserCenter().isDb()) {
                YkzUserService ykzUserService = (YkzUserService)this.applicationContext.getBean(YkzUserService.class);
                ykzUserService.saveErrorMsg(JackSonUtil.toJson((Object)YKZ_ERROR_MSG.get()));
            }
            return (Result)YKZ_ERROR_MSG.get();
        }
        ykzUser.setMobile(phone);
        if (this.ykzProperties.getUserCenter().isDb()) {
            YkzUserService ykzUserService = (YkzUserService)this.applicationContext.getBean(YkzUserService.class);
            ykzUserService.saveOne(ykzUser);
        }
        return Result.ok((Object)ykzUser);
    }

    @Override
    public Result<List<YkzUserPost>> userPostByZwddId(String zwddId) {
        JSONObject jsonObject = JSONUtil.createObj().set("accountId", (Object)zwddId);
        List<YkzUserPost> ykzUserPostList = this.sendRequestList(this.ykzProperties.getUserCenter().getUserPostByZwddId(), true, jsonObject, YkzUserPost.class);
        log.info("\u83b7\u53d6\u4eba\u5458\u804c\u52a1\u4fe1\u606f\u6761\u6570\uff1a{}", (Object)ykzUserPostList.size());
        if (cn.hutool.core.collection.CollUtil.isEmpty(ykzUserPostList)) {
            if (this.ykzProperties.getUserCenter().isDb()) {
                YkzUserPostService ykzUserPostService = (YkzUserPostService)this.applicationContext.getBean(YkzUserPostService.class);
                ykzUserPostService.saveErrorMsg(JackSonUtil.toJson((Object)YKZ_ERROR_MSG.get()));
            }
            return (Result)YKZ_ERROR_MSG.get();
        }
        ykzUserPostList.forEach(et -> et.setAccountId(zwddId));
        if (this.ykzProperties.getUserCenter().isDb()) {
            YkzUserPostService ykzUserPostService = (YkzUserPostService)this.applicationContext.getBean(YkzUserPostService.class);
            ykzUserPostService.saveBatchDb(ykzUserPostList);
        }
        return Result.ok(ykzUserPostList);
    }

    @Override
    public Result<List<YkzUser>> userByMobileList(List<String> phoneList) {
        JSONObject jsonObject = JSONUtil.createObj().set("mobiles", phoneList);
        List<YkzUser> ykzUserList = this.sendRequestList(this.ykzProperties.getUserCenter().getUserByMobileList(), true, jsonObject, YkzUser.class);
        return this.getYkzUserListResult(ykzUserList);
    }

    @Override
    public Result<YkzUser> userByZwddId(String zwddId) {
        JSONObject jsonObject = JSONUtil.createObj().set("accountId", (Object)zwddId);
        YkzUser ykzUser = this.sendRequestOne(this.ykzProperties.getUserCenter().getUserByZwddId(), true, jsonObject, YkzUser.class);
        if (Objects.isNull(ykzUser)) {
            if (this.ykzProperties.getUserCenter().isDb()) {
                YkzUserService ykzUserService = (YkzUserService)this.applicationContext.getBean(YkzUserService.class);
                ykzUserService.saveErrorMsg(JackSonUtil.toJson((Object)YKZ_ERROR_MSG.get()));
            }
            return (Result)YKZ_ERROR_MSG.get();
        }
        if (this.ykzProperties.getUserCenter().isDb()) {
            YkzUserService ykzUserService = (YkzUserService)this.applicationContext.getBean(YkzUserService.class);
            ykzUserService.saveOne(ykzUser);
        }
        return Result.ok((Object)ykzUser);
    }

    @Override
    public Result<List<YkzUser>> userByZwddIdList(List<String> zwddIdList) {
        JSONObject jsonObject = JSONUtil.createObj().set("accountIds", zwddIdList);
        List<YkzUser> ykzUserList = this.sendRequestList(this.ykzProperties.getUserCenter().getUserByZwddIdList(), true, jsonObject, YkzUser.class);
        return this.getYkzUserListResult(ykzUserList);
    }

    @Override
    public Result<YkzLabel> userTagByZwddId(String zwddId) {
        JSONObject jsonObject = JSONUtil.createObj().set("accountId", (Object)zwddId);
        YkzLabel ykzLabel = this.sendRequestOne(this.ykzProperties.getUserCenter().getUserTagByZwddId(), true, jsonObject, YkzLabel.class);
        if (Objects.isNull(ykzLabel)) {
            return (Result)YKZ_ERROR_MSG.get();
        }
        return Result.ok((Object)ykzLabel);
    }

    @Override
    public Result<YkzLabel> userTagByMobile(String phone) {
        JSONObject jsonObject = JSONUtil.createObj().set("mobile", (Object)phone);
        YkzLabel ykzLabel = this.sendRequestOne(this.ykzProperties.getUserCenter().getUserTagByMobile(), true, jsonObject, YkzLabel.class);
        if (Objects.isNull(ykzLabel)) {
            return (Result)YKZ_ERROR_MSG.get();
        }
        return Result.ok((Object)ykzLabel);
    }

    @Override
    public Result<List<YkzLabel>> userTagByZwddIdList(List<String> zwddIdList) {
        JSONObject jsonObject = JSONUtil.createObj().set("accountIds", zwddIdList);
        List<YkzLabel> ykzLabelList = this.sendRequestList(this.ykzProperties.getUserCenter().getUserTagByZwddIdList(), true, jsonObject, YkzLabel.class);
        if (cn.hutool.core.collection.CollUtil.isEmpty(ykzLabelList)) {
            return (Result)YKZ_ERROR_MSG.get();
        }
        return Result.ok(ykzLabelList);
    }

    @Override
    public Result<List<YkzLabel>> userTagByMobileList(List<String> phoneList) {
        JSONObject jsonObject = JSONUtil.createObj().set("mobiles", phoneList);
        List<YkzLabel> ykzLabelList = this.sendRequestList(this.ykzProperties.getUserCenter().getUserTagByMobileList(), true, jsonObject, YkzLabel.class);
        if (cn.hutool.core.collection.CollUtil.isEmpty(ykzLabelList)) {
            return (Result)YKZ_ERROR_MSG.get();
        }
        return Result.ok(ykzLabelList);
    }

    private Result<List<YkzUser>> getYkzUserListResult(List<YkzUser> ykzUserList) {
        if (cn.hutool.core.collection.CollUtil.isEmpty(ykzUserList)) {
            if (this.ykzProperties.getUserCenter().isDb()) {
                YkzUserService ykzUserService = (YkzUserService)this.applicationContext.getBean(YkzUserService.class);
                ykzUserService.saveErrorMsg(JackSonUtil.toJson((Object)YKZ_ERROR_MSG.get()));
            }
            return (Result)YKZ_ERROR_MSG.get();
        }
        if (this.ykzProperties.getUserCenter().isDb()) {
            YkzUserService ykzUserService = (YkzUserService)this.applicationContext.getBean(YkzUserService.class);
            ykzUserService.saveBatchDb(ykzUserList);
        }
        return Result.ok(ykzUserList);
    }

    private String setRequestHeader() {
        log.info("accessToken: {},expiresInDate: {}", (Object)accessToken, (Object)expiresInDate);
        if (Objects.nonNull(expiresInDate) && Objects.nonNull(accessToken) && DateUtil.between((Date)new Date(), (Date)expiresInDate, (DateUnit)DateUnit.SECOND, (boolean)false) >= 0L) {
            return accessToken;
        }
        YkzAccessToken centerAccessToken = this.getAccessToken();
        if (Objects.isNull(centerAccessToken)) {
            return null;
        }
        return centerAccessToken.getAccessToken();
    }

    public List<YkzOrg> childOrg(String orgCode, Integer pageNumber, Integer pageSize) {
        JSONObject jsonObject = JSONUtil.createObj().set("organizationCode", (Object)orgCode).set("pageNumber", (Object)pageNumber).set("pageSize", (Object)pageSize);
        YkzOrgPage ykzOrgPage = this.sendRequestOne(this.ykzProperties.getUserCenter().getOrgByParentCode(), true, jsonObject, YkzOrgPage.class);
        log.info("orgByParentCode-childOrg \u5f53\u524d\u9875\uff1a{},\u6bcf\u9875\u6570\u91cf\uff1a{},\u603b\u6570\u91cf\uff1a{},\u603b\u9875\u6570\uff1a{}", new Object[]{ykzOrgPage.getPageNumber(), ykzOrgPage.getPageSize(), ykzOrgPage.getTotal(), ykzOrgPage.getTotalPage()});
        List<YkzOrg> list = ykzOrgPage.getList();
        if (cn.hutool.core.collection.CollUtil.isEmpty(list)) {
            return null;
        }
        CopyOnWriteArrayList<YkzOrg> resultList = new CopyOnWriteArrayList<YkzOrg>(list);
        Integer resultPageNumber = ykzOrgPage.getPageNumber();
        Integer resultTotalPage = ykzOrgPage.getTotalPage();
        if (resultPageNumber < resultTotalPage) {
            Integer i = resultPageNumber + 1;
            while (i <= resultTotalPage) {
                List<YkzOrg> ykzOrgs = this.childOrg(orgCode, i, pageSize);
                resultList.addAll(ykzOrgs);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        if (cn.hutool.core.collection.CollUtil.isNotEmpty(list)) {
            list.parallelStream().forEach(et -> {
                List<YkzOrg> ykzOrgList = this.childOrg(et.getOrganizationCode(), 1, pageSize);
                if (cn.hutool.core.collection.CollUtil.isNotEmpty(ykzOrgList)) {
                    resultList.addAll(ykzOrgList);
                }
            });
        }
        return resultList;
    }
}

