/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.common.constant.CommonConstant;
import com.efficient.common.result.Result;
import com.efficient.system.api.SysUnitService;
import com.efficient.system.api.SysUserPostService;
import com.efficient.system.api.SysUserService;
import com.efficient.system.model.entity.SysUnit;
import com.efficient.system.model.entity.SysUser;
import com.efficient.system.model.entity.SysUserPost;
import com.efficient.ykz.api.YkzUserCenterHandleService;
import com.efficient.ykz.model.vo.YkzOrg;
import com.efficient.ykz.model.vo.YkzUser;
import com.efficient.ykz.model.vo.YkzUserPost;
import com.efficient.ykz.service.YkzCommonServer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class YkzUserCenterHandleDefaultService
implements YkzUserCenterHandleService {
    private static final Logger log = LoggerFactory.getLogger(YkzUserCenterHandleDefaultService.class);
    @Autowired
    private SysUnitService sysUnitService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserPostService sysUserPostService;
    @Autowired
    private YkzCommonServer ykzCommonServer;

    private void setChild(YkzOrg ykzOrg) {
        this.handleOrgByCode(ykzOrg);
        List<YkzOrg> children = ykzOrg.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            for (YkzOrg child : children) {
                this.setChild(child);
            }
        }
    }

    private void setSysUser(SysUser sysUser, YkzUser data) {
        sysUser.setId(String.valueOf(data.getId()));
        sysUser.setName(data.getName());
        sysUser.setAccount(data.getUsername());
        sysUser.setPassword(this.ykzCommonServer.encrypt("Sjr@1809"));
        sysUser.setZwddId(data.getAccountId());
        sysUser.setPhone(data.getMobile());
        sysUser.setIsEnable(CommonConstant.TRUE_INT);
        sysUser.setCreateTime(new Date());
        sysUser.setIsDelete(CommonConstant.FALSE_INT);
        sysUser.setPullTime(new Date());
    }

    @Override
    public Result<YkzOrg> handleOrgByCode(YkzOrg data) {
        Long id = data.getId();
        SysUnit sysUnit = (SysUnit)this.sysUnitService.getById((Serializable)((Object)String.valueOf(id)));
        if (Objects.nonNull(sysUnit)) {
            log.info("\u5355\u4f4d\u5df2\u5b58\u5728,\u672a\u5165\u5e93\uff1a\u540d\u79f0: {},id: {}", (Object)data.getName(), (Object)data.getId());
        } else {
            sysUnit = new SysUnit();
            this.setSysUnit(sysUnit, data);
            this.sysUnitService.save((Object)sysUnit);
        }
        return Result.ok((Object)data);
    }

    @Override
    public Result<List<YkzOrg>> handleOrgByCodeList(List<YkzOrg> data) {
        for (YkzOrg ykzOrg : data) {
            this.handleOrgByCode(ykzOrg);
        }
        return Result.ok(data);
    }

    @Override
    public Result<List<YkzOrg>> handleOrgByParentCode(String orgCode, boolean includeTop, boolean flattenTree, List<YkzOrg> data) {
        if (StrUtil.equalsAny((CharSequence)orgCode, (CharSequence[])new CharSequence[]{"GO_1065d20ebe964b4d9da264cfe5e5d240", "575324d0-2257-4f53-8e5f-ca72d992abe9"})) {
            YkzOrg ykzOrg = data.get(0);
            List<YkzOrg> children = ykzOrg.getChildren();
            for (YkzOrg child : children) {
                this.setChild(child);
            }
        } else {
            for (YkzOrg ykzOrg : data) {
                this.setChild(ykzOrg);
            }
        }
        return Result.ok(data);
    }

    @Override
    public Result<YkzUser> handleUserByMobile(YkzUser data) {
        SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)data.getId());
        if (Objects.nonNull(sysUser)) {
            log.info("\u4eba\u5458\u5df2\u5b58\u5728,\u672a\u5165\u5e93\uff1a\u540d\u79f0: {},id: {}", (Object)data.getName(), (Object)data.getId());
        } else {
            sysUser = new SysUser();
            this.setSysUser(sysUser, data);
            this.sysUserService.save((Object)sysUser);
        }
        return Result.ok((Object)data);
    }

    @Override
    public Result<List<YkzUser>> handleUserByMobileList(List<YkzUser> data) {
        for (YkzUser ykzUser : data) {
            this.handleUserByMobile(ykzUser);
        }
        return Result.ok(data);
    }

    @Override
    public Result<YkzUser> handleUserByZwddId(YkzUser data) {
        return this.handleUserByMobile(data);
    }

    @Override
    public Result<List<YkzUser>> handleUserByZwddIdList(List<YkzUser> data) {
        return this.handleUserByMobileList(data);
    }

    @Override
    public Result<List<YkzUserPost>> handleUserPostByZwddId(List<YkzUserPost> data) {
        ArrayList<SysUserPost> sysUserPostList = new ArrayList<SysUserPost>();
        SysUser sysUser = this.sysUserService.getByZwddId(data.get(0).getAccountId());
        for (YkzUserPost ykzUserPost : data) {
            String organizationCode = ykzUserPost.getOrganizationCode();
            SysUnit sysUnit = this.sysUnitService.getByOrgCode(organizationCode);
            if (Objects.isNull(sysUnit)) {
                log.error("\u4eba\u5458\u804c\u52a1\u6240\u5728\u5355\u4f4d\u672a\u5165\u5e93\uff1aorgCode: {}", (Object)organizationCode);
                continue;
            }
            String zwddId = ykzUserPost.getAccountId();
            String id = sysUnit.getId() + "_" + zwddId;
            if (Objects.isNull(sysUser)) {
                log.error("\u4eba\u5458\u4fe1\u606f\u672a\u5165\u5e93\uff1azwddId: {}", (Object)zwddId);
                continue;
            }
            SysUserPost sysUserPost = (SysUserPost)this.sysUserPostService.getById((Serializable)((Object)id));
            if (Objects.nonNull(sysUserPost)) {
                log.info("\u7528\u6237\u804c\u52a1\u5df2\u5b58\u5728,\u672a\u5165\u5e93\uff1a\u540d\u79f0: {},id: {}", (Object)organizationCode, (Object)zwddId);
                continue;
            }
            sysUserPost = new SysUserPost();
            sysUserPost.setId(id);
            sysUserPost.setUserId(sysUser.getId());
            sysUserPost.setDeptId(sysUnit.getId());
            sysUserPost.setDeptLevelCode(sysUnit.getLevelCode());
            SysUnit unitInfo = this.sysUnitService.getUnitByDeptId(sysUnit.getId());
            if (Objects.nonNull(unitInfo)) {
                sysUserPost.setUnitId(unitInfo.getId());
                sysUserPost.setUnitLevelCode(unitInfo.getLevelCode());
            }
            sysUserPost.setPermissionType("1");
            Integer postType = ykzUserPost.getPostType();
            sysUserPost.setMainJob(Integer.valueOf(Objects.equals(postType, 1) ? 1 : 0));
            sysUserPost.setPostName(ykzUserPost.getPosJob());
            sysUserPost.setCreateTime(new Date());
            sysUserPost.setIsDelete(CommonConstant.FALSE_INT);
            sysUserPost.setPullTime(new Date());
            sysUserPostList.add(sysUserPost);
        }
        if (CollUtil.isNotEmpty(sysUserPostList)) {
            SysUserPost userPost = this.sysUserPostService.getMainByUserId(sysUser.getId());
            if (Objects.isNull(userPost)) {
                ((SysUserPost)sysUserPostList.get(0)).setMainJob(CommonConstant.TRUE_INT);
            }
            this.sysUserPostService.saveOrUpdateBatch(sysUserPostList);
        }
        return Result.ok(data);
    }

    private void setSysUnit(SysUnit sysUnit, YkzOrg data) {
        sysUnit.setId(String.valueOf(data.getId()));
        sysUnit.setParentId(String.valueOf(data.getParentId()));
        sysUnit.setName(data.getName());
        sysUnit.setSortName(data.getGovShortName());
        String levelCode = this.sysUnitService.createLevelCode(String.valueOf(data.getParentId()));
        sysUnit.setLevelCode(levelCode);
        sysUnit.setUnitType(YkzUserCenterHandleService.getUnitType(data.getOrgType()));
        sysUnit.setSort(data.getDisplayOrder());
        sysUnit.setAddress(data.getGovAddress());
        sysUnit.setGeocode(data.getGovDivisionCode());
        sysUnit.setOrgCode(data.getOrganizationCode());
        sysUnit.setParentOrgCode(data.getParentOrganizationCode());
        sysUnit.setCreditCode(data.getCreditCode());
        sysUnit.setAreaLevel(data.getAreaLevel());
        sysUnit.setPrincipal(data.getPrincipal());
        sysUnit.setBelong(this.sysUnitService.getBelongById(sysUnit.getId()));
        sysUnit.setRemark(data.getRemark());
        sysUnit.setIsEnable(data.getIsEnable());
        sysUnit.setCreateTime(new Date(data.getCreateTime()));
        sysUnit.setUpdateTime(new Date(data.getUpdateTime()));
        sysUnit.setIsDelete(data.getIsDeleted());
        sysUnit.setPullTime(new Date());
    }
}

