/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.dcqc.uc.oauth.sdk.util.JwtHelper;
import com.dcqc.uc.oauth.sdk.util.SM2ToolUtil;
import com.efficient.common.result.Result;
import com.efficient.common.util.IdUtil;
import com.efficient.common.util.JackSonUtil;
import com.efficient.ykz.api.YkzUserCenterService;
import com.efficient.ykz.model.dto.YkzParam;
import com.efficient.ykz.model.vo.YkzOrg;
import com.efficient.ykz.model.vo.YkzResult;
import com.efficient.ykz.model.vo.YkzUser;
import com.efficient.ykz.model.vo.YkzUserCenterAccessToken;
import com.efficient.ykz.model.vo.YkzUserPost;
import com.efficient.ykz.properties.YkzProperties;
import java.util.Objects;
import javax.annotation.Resource;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YkzUserCenterServiceImpl
implements YkzUserCenterService {
    private static final Logger log = LoggerFactory.getLogger(YkzUserCenterServiceImpl.class);
    @Resource
    JwtHelper jwtHelper;
    @Autowired
    private YkzProperties ykzProperties;

    @Override
    public Result orgByCode(String orgCode) {
        JSONObject jsonObject = JSONUtil.createObj().set("organizationCode", (Object)orgCode);
        YkzOrg ykzOrg = this.sendRequest(this.ykzProperties.getUserCenter().getOrgByCode(), true, jsonObject, YkzOrg.class);
        return Objects.isNull(ykzOrg) ? Result.fail() : Result.ok((Object)ykzOrg);
    }

    @Override
    public YkzUserCenterAccessToken getAccessToken(String appId, String appSecret) {
        if (StrUtil.isBlank((CharSequence)appId)) {
            appId = this.ykzProperties.getIp();
        }
        if (StrUtil.isBlank((CharSequence)appSecret)) {
            appSecret = this.ykzProperties.getAppSecret();
        }
        JSONObject jsonObject = JSONUtil.createObj().set("appId", (Object)appId).set("appSecret", (Object)SM2ToolUtil.sm2Encode((BCECPublicKey)this.jwtHelper.getPublicKey(), (String)appSecret));
        return this.sendRequest(this.ykzProperties.getUserCenter().getAccessTokenUrl(), false, jsonObject, YkzUserCenterAccessToken.class);
    }

    @Override
    public YkzUserCenterAccessToken getAccessToken() {
        return this.getAccessToken(null, null);
    }

    @Override
    public <M> M sendRequest(String url, JSONObject params, Class<M> tClass) {
        HttpRequest httpRequest = HttpRequest.post((String)(this.ykzProperties.getIp() + url));
        httpRequest.contentType("application/json;charset=utf-8");
        YkzParam ykzParam = YkzParam.builder().requestId(IdUtil.uuid()).data(params.toString()).build();
        httpRequest.body(JackSonUtil.toJson((Object)ykzParam));
        HttpResponse response = httpRequest.execute();
        log.info("{} \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)url, (Object)response.body());
        YkzResult ykzResult = (YkzResult)JackSonUtil.toObject((String)response.body(), YkzResult.class);
        if (Objects.isNull(ykzResult) || Objects.equals(Boolean.FALSE, ykzResult.getSuccess()) || Objects.isNull(ykzResult.getData())) {
            return null;
        }
        return (M)JackSonUtil.toObject((String)String.valueOf(ykzResult.getData()), tClass);
    }

    @Override
    public <M> M sendRequest(String url, boolean hasToken, JSONObject params, Class<M> tClass) {
        HttpRequest httpRequest = HttpRequest.post((String)(this.ykzProperties.getIp() + url));
        httpRequest.contentType("application/json;charset=utf-8");
        YkzParam ykzParam = YkzParam.builder().requestId(IdUtil.uuid()).data(params.toString()).build();
        httpRequest.body(JackSonUtil.toJson((Object)ykzParam));
        if (hasToken) {
            YkzUserCenterAccessToken centerAccessToken = this.getAccessToken();
            if (Objects.isNull(centerAccessToken)) {
                return null;
            }
            httpRequest.header("Authorization", "Bearer " + centerAccessToken.getAccessToken());
        }
        HttpResponse response = httpRequest.execute();
        log.info("{} \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)url, (Object)response.body());
        YkzResult ykzResult = (YkzResult)JackSonUtil.toObject((String)response.body(), YkzResult.class);
        if (Objects.isNull(ykzResult) || Objects.equals(Boolean.FALSE, ykzResult.getSuccess()) || Objects.isNull(ykzResult.getData())) {
            return null;
        }
        return (M)JackSonUtil.toObject((String)String.valueOf(ykzResult.getData()), tClass);
    }

    @Override
    public Result userByMobile(String phone) {
        JSONObject jsonObject = JSONUtil.createObj().set("mobile", (Object)phone);
        YkzUser ykzUser = this.sendRequest(this.ykzProperties.getUserCenter().getUserByMobile(), true, jsonObject, YkzUser.class);
        if (Objects.isNull(ykzUser)) {
            return Result.fail();
        }
        ykzUser.setPhone(phone);
        return Result.ok((Object)ykzUser);
    }

    @Override
    public Result userPostByZwddId(String zwddId) {
        JSONObject jsonObject = JSONUtil.createObj().set("accountId", (Object)zwddId);
        YkzUserPost ykzUserPost = this.sendRequest(this.ykzProperties.getUserCenter().getUserByMobile(), true, jsonObject, YkzUserPost.class);
        return Objects.isNull(ykzUserPost) ? Result.fail() : Result.ok((Object)ykzUserPost);
    }
}

