/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.controller;

import com.efficient.common.result.Result;
import com.efficient.ykz.api.YkzUserCenterService;
import com.efficient.ykz.model.vo.YkzLabel;
import com.efficient.ykz.model.vo.YkzOrg;
import com.efficient.ykz.model.vo.YkzUser;
import com.efficient.ykz.model.vo.YkzUserPost;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ykz/userCenter/"})
@Validated
public class YkzUserCenterController {
    @Autowired
    private YkzUserCenterService ykzUserCenterService;

    @GetMapping(value={"/org/orgByCode"})
    public Result<YkzOrg> orgByCode(@NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="orgCode") @NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") String orgCode) throws Exception {
        return this.ykzUserCenterService.orgByCode(orgCode);
    }

    @PostMapping(value={"/org/orgByCodeList"})
    public Result<List<YkzOrg>> orgByCodeList(@RequestBody List<String> orgCodeList) throws Exception {
        return this.ykzUserCenterService.orgByCodeList(orgCodeList);
    }

    @GetMapping(value={"/org/orgByParentCode"})
    public Result<List<YkzOrg>> orgByParentCode(@NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="orgCode") @NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") String orgCode, @NotNull(message="pageNum \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="pageNum") @NotNull(message="pageNum \u4e0d\u80fd\u4e3a\u7a7a") Integer pageNum, @NotNull(message="pageSize \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="pageSize") @NotNull(message="pageSize \u4e0d\u80fd\u4e3a\u7a7a") Integer pageSize, @RequestParam(name="includeTop", required=false, defaultValue="true") boolean includeTop) throws Exception {
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (pageSize < 20) {
            pageSize = 20;
        }
        return this.ykzUserCenterService.orgByParentCode(orgCode, pageNum, pageSize, includeTop);
    }

    @GetMapping(value={"/user/userByMobile"})
    public Result<YkzUser> userByMobile(@NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="phone") @NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") String phone) throws Exception {
        return this.ykzUserCenterService.userByMobile(phone);
    }

    @PostMapping(value={"/user/userByMobileList"})
    public Result<List<YkzUser>> userByMobileList(@RequestBody List<String> phoneList) throws Exception {
        return this.ykzUserCenterService.userByMobileList(phoneList);
    }

    @GetMapping(value={"/user/userByZwddId"})
    public Result<YkzUser> userByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        return this.ykzUserCenterService.userByZwddId(zwddId);
    }

    @PostMapping(value={"/user/userByZwddIdList"})
    public Result<List<YkzUser>> userByZwddIdList(@RequestBody List<String> zwddIdList) throws Exception {
        return this.ykzUserCenterService.userByZwddIdList(zwddIdList);
    }

    @GetMapping(value={"/userPost/userPostByZwddId"})
    public Result<List<YkzUserPost>> userPostByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        return this.ykzUserCenterService.userPostByZwddId(zwddId);
    }

    @GetMapping(value={"/userTag/userTagByZwddId"})
    public Result<YkzLabel> userTagByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        return this.ykzUserCenterService.userTagByZwddId(zwddId);
    }

    @GetMapping(value={"/userTag/userTagByMobile"})
    public Result<YkzLabel> userTagByMobile(@NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="phone") @NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") String phone) throws Exception {
        return this.ykzUserCenterService.userTagByMobile(phone);
    }

    @PostMapping(value={"/userTag/userTagByZwddIdList"})
    public Result<List<YkzLabel>> userTagByZwddIdList(@RequestBody List<String> zwddIdList) throws Exception {
        return this.ykzUserCenterService.userTagByZwddIdList(zwddIdList);
    }

    @PostMapping(value={"/userTag/userTagByMobileList"})
    public Result<List<YkzLabel>> userTagByMobileList(@RequestBody List<String> phoneList) throws Exception {
        return this.ykzUserCenterService.userTagByMobileList(phoneList);
    }
}

