/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.controller;

import com.dcqc.uc.oauth.sdk.model.Request;
import com.dcqc.uc.oauth.sdk.model.Result;
import com.dcqc.uc.oauth.sdk.model.v3.SynchronizeV3DTO;
import com.efficient.ykz.api.YkzUserCenterService;
import com.efficient.ykz.api.YkzUserCenterSyncService;
import com.efficient.ykz.model.vo.YkzLabel;
import com.efficient.ykz.model.vo.YkzOrg;
import com.efficient.ykz.model.vo.YkzUser;
import com.efficient.ykz.model.vo.YkzUserPost;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ykz/userCenter/"})
@Validated
public class YkzUserCenterController {
    private static final Logger log = LoggerFactory.getLogger(YkzUserCenterController.class);
    @Autowired
    private YkzUserCenterService ykzUserCenterService;
    @Autowired
    private ApplicationContext applicationContext;

    @GetMapping(value={"/org/orgByCode"})
    public com.efficient.common.result.Result<YkzOrg> orgByCode(@NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="orgCode") @NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") String orgCode) throws Exception {
        return this.ykzUserCenterService.orgByCode(orgCode);
    }

    @PostMapping(value={"/org/orgByCodeList"})
    public com.efficient.common.result.Result<List<YkzOrg>> orgByCodeList(@RequestBody List<String> orgCodeList) throws Exception {
        return this.ykzUserCenterService.orgByCodeList(orgCodeList);
    }

    @GetMapping(value={"/org/orgByParentCode"})
    public com.efficient.common.result.Result<List<YkzOrg>> orgByParentCode(@NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="orgCode") @NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") String orgCode, @NotNull(message="pageNum \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="pageNum") @NotNull(message="pageNum \u4e0d\u80fd\u4e3a\u7a7a") Integer pageNum, @NotNull(message="pageSize \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="pageSize") @NotNull(message="pageSize \u4e0d\u80fd\u4e3a\u7a7a") Integer pageSize, @RequestParam(name="includeTop", required=false, defaultValue="true") boolean includeTop, @RequestParam(name="flattenTree", required=false, defaultValue="false") boolean flattenTree) throws Exception {
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (pageSize < 20) {
            pageSize = 20;
        }
        return this.ykzUserCenterService.orgByParentCode(orgCode, pageNum, pageSize, includeTop, flattenTree);
    }

    @GetMapping(value={"/user/userByMobile"})
    public com.efficient.common.result.Result<YkzUser> userByMobile(@NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="phone") @NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") String phone) throws Exception {
        return this.ykzUserCenterService.userByMobile(phone);
    }

    @PostMapping(value={"/user/userByMobileList"})
    public com.efficient.common.result.Result<List<YkzUser>> userByMobileList(@RequestBody List<String> phoneList) throws Exception {
        return this.ykzUserCenterService.userByMobileList(phoneList);
    }

    @GetMapping(value={"/user/userByZwddId"})
    public com.efficient.common.result.Result<YkzUser> userByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        return this.ykzUserCenterService.userByZwddId(zwddId);
    }

    @PostMapping(value={"/user/userByZwddIdList"})
    public com.efficient.common.result.Result<List<YkzUser>> userByZwddIdList(@RequestBody List<String> zwddIdList) throws Exception {
        return this.ykzUserCenterService.userByZwddIdList(zwddIdList);
    }

    @GetMapping(value={"/userPost/userPostByZwddId"})
    public com.efficient.common.result.Result<List<YkzUserPost>> userPostByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        return this.ykzUserCenterService.userPostByZwddId(zwddId);
    }

    @GetMapping(value={"/userTag/userTagByZwddId"})
    public com.efficient.common.result.Result<YkzLabel> userTagByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        return this.ykzUserCenterService.userTagByZwddId(zwddId);
    }

    @GetMapping(value={"/userTag/userTagByMobile"})
    public com.efficient.common.result.Result<YkzLabel> userTagByMobile(@NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="phone") @NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") String phone) throws Exception {
        return this.ykzUserCenterService.userTagByMobile(phone);
    }

    @PostMapping(value={"/userTag/userTagByZwddIdList"})
    public com.efficient.common.result.Result<List<YkzLabel>> userTagByZwddIdList(@RequestBody List<String> zwddIdList) throws Exception {
        return this.ykzUserCenterService.userTagByZwddIdList(zwddIdList);
    }

    @PostMapping(value={"/userTag/userTagByMobileList"})
    public com.efficient.common.result.Result<List<YkzLabel>> userTagByMobileList(@RequestBody List<String> phoneList) throws Exception {
        return this.ykzUserCenterService.userTagByMobileList(phoneList);
    }

    @PostMapping(value={"/ykz/sync"})
    public Result<Boolean> ykzSync(@RequestBody @Validated Request<SynchronizeV3DTO> request) {
        Result objectResult = new Result();
        try {
            SynchronizeV3DTO synchronizeV3DTO = (SynchronizeV3DTO)request.getData();
            YkzUserCenterSyncService userCenterSyncService = (YkzUserCenterSyncService)this.applicationContext.getBean(YkzUserCenterSyncService.class);
            userCenterSyncService.ykzSync(synchronizeV3DTO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            objectResult.setFailed(e.getMessage());
        }
        return objectResult;
    }
}

