/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.config;

import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.efficient.ykz.properties.YkzApi;
import com.efficient.ykz.properties.YkzProperties;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={YkzProperties.class})
public class YkzConfig {
    private static final Logger log = LoggerFactory.getLogger(YkzConfig.class);
    private final AtomicReference<ExecutableClient> executableClientRef = new AtomicReference();
    @Autowired
    private YkzProperties ykzProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableClient getExecutableClient() {
        ExecutableClient currentClient = this.executableClientRef.get();
        if (Objects.isNull(currentClient)) {
            YkzConfig ykzConfig = this;
            synchronized (ykzConfig) {
                currentClient = this.executableClientRef.get();
                if (Objects.isNull(currentClient)) {
                    currentClient = this.init();
                    this.executableClientRef.set(currentClient);
                }
            }
        }
        return currentClient;
    }

    public ExecutableClient init() {
        log.info("\u521d\u59cb\u5316\u6e1d\u5feb\u653f executableClient");
        ExecutableClient executableClient = ExecutableClient.getInstance();
        YkzApi ykzApi = this.ykzProperties.getYkzApi();
        executableClient.setDomainName(ykzApi.getDomainName());
        executableClient.setProtocal(ykzApi.getProtocal());
        executableClient.setAccessKey(ykzApi.getAppkey());
        executableClient.setSecretKey(ykzApi.getAppsecret());
        executableClient.init();
        return executableClient;
    }
}

