/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.controller;

import com.efficient.common.permission.Permission;
import com.efficient.common.result.Result;
import com.efficient.ykz.api.YkzApiService;
import com.efficient.ykz.model.dto.msg.YkzSendMsg;
import com.efficient.ykz.model.dto.todo.YkzTodoInfo;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNotice;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNoticeBackOut;
import com.efficient.ykz.model.vo.YkzAccessToken;
import com.efficient.ykz.model.vo.YkzLoginToken;
import com.efficient.ykz.model.vo.YkzLoginUser;
import com.efficient.ykz.model.vo.YkzTodoInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ykz/api/"})
@Validated
@Api(tags={"\u6e1d\u5feb\u653f-\u6d88\u606f\u63a5\u53e3"})
@Permission
public class YkzApiController {
    @Autowired
    private YkzApiService ykzApiService;

    @GetMapping(value={"/login/accessToken"})
    @ApiOperation(value="\u83b7\u53d6accessToken", response=YkzAccessToken.class)
    public Result<YkzAccessToken> accessToken() {
        return this.ykzApiService.accessToken();
    }

    @GetMapping(value={"/login/getUserInfo"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", response=YkzLoginUser.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="authCode", value="\u6e1d\u5feb\u653fauthCode", required=true)})
    public Result<YkzLoginUser> getUserInfo(@RequestParam(value="authCode") String authCode) {
        return this.ykzApiService.getUserInfo(authCode);
    }

    @GetMapping(value={"/login/getTokenInfo"})
    @ApiOperation(value="\u6839\u636eauthCode\u83b7\u53d6\u767b\u5f55token", response=YkzLoginToken.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="authCode", value="\u6e1d\u5feb\u653fauthCode", required=true)})
    public Result<YkzLoginToken> getTokenInfo(@RequestParam(value="authCode") String authCode) {
        return this.ykzApiService.getTokenInfo(authCode);
    }

    @PostMapping(value={"/msg/send"})
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f", response=String.class)
    public Result<String> sendMsg(@RequestBody YkzSendMsg ykzSendMsg) {
        return this.ykzApiService.sendMsg(ykzSendMsg);
    }

    @PostMapping(value={"/workNotice/send"})
    @ApiOperation(value="\u5de5\u4f5c\u901a\u77e5-\u53d1\u9001", response=String.class)
    public Result<String> sendWorkNotice(@RequestBody YkzWorkNotice ykzWorkNotice) {
        return this.ykzApiService.sendWorkNotice(ykzWorkNotice);
    }

    @PostMapping(value={"/workNotice/revoke"})
    @ApiOperation(value="\u5de5\u4f5c\u901a\u77e5-\u64a4\u9500", response=String.class)
    public Result<String> revokeWorkNotice(@RequestBody YkzWorkNoticeBackOut ykzWorkNotice) {
        return this.ykzApiService.revokeWorkNotice(ykzWorkNotice);
    }

    @PostMapping(value={"/todo/create"})
    @ApiOperation(value="\u5f85\u529e-\u521b\u5efa", response=YkzTodoInfoVO.class)
    public Result<YkzTodoInfoVO> createTodo(@RequestBody YkzTodoInfo todoInfo) {
        return this.ykzApiService.createTodo(todoInfo);
    }

    @GetMapping(value={"/todo/finish"})
    @ApiOperation(value="\u5f85\u529e-\u5b8c\u6210", response=String.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="assigneeId", value="\u63a5\u6536\u4ebaID", required=true), @ApiImplicitParam(name="taskUuid", value="\u4efb\u52a1ID", required=true), @ApiImplicitParam(name="closePackage", value="\u5173\u95ed\u7a7a\u95f4", required=false)})
    public Result<String> finishTodo(@RequestParam(value="assigneeId") String assigneeId, @RequestParam(value="taskUuid") String taskUuid, @RequestParam(value="closePackage", required=false, defaultValue="false") boolean closePackage) {
        return this.ykzApiService.finishTodo(assigneeId, taskUuid, closePackage);
    }

    @GetMapping(value={"/todo/cancel"})
    @ApiOperation(value="\u5f85\u529e-\u5b8c\u6210", response=String.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="assigneeId", value="\u63a5\u6536\u4ebaID", required=true), @ApiImplicitParam(name="taskUuid", value="\u4efb\u52a1ID", required=true), @ApiImplicitParam(name="closePackage", value="\u5173\u95ed\u7a7a\u95f4", required=false)})
    public Result<String> cancelTodo(@RequestParam(value="assigneeId") String assigneeId, @RequestParam(value="taskUuid") String taskUuid, @RequestParam(value="closePackage", required=false, defaultValue="false") boolean closePackage) {
        return this.ykzApiService.cancelTodo(assigneeId, taskUuid, closePackage);
    }
}

