/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.util;

import cn.hutool.core.collection.CollUtil;
import com.efficient.ykz.model.vo.YkzOrg;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class YkzUtil {
    public static List<YkzOrg> createTree(List<YkzOrg> ykzOrgList, boolean flattenTree) {
        if (CollUtil.isEmpty(ykzOrgList)) {
            return ykzOrgList;
        }
        HashMap<Long, YkzOrg> idToNodeMap = new HashMap<Long, YkzOrg>();
        ArrayList<YkzOrg> roots = new ArrayList<YkzOrg>();
        for (YkzOrg node : ykzOrgList) {
            idToNodeMap.put(node.getId(), node);
        }
        for (YkzOrg node : ykzOrgList) {
            Long parentId = node.getParentId();
            if (idToNodeMap.get(parentId) != null) {
                YkzOrg parent = (YkzOrg)idToNodeMap.get(parentId);
                if (parent == null) continue;
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList<YkzOrg>());
                }
                parent.getChildren().add(node);
                continue;
            }
            roots.add(node);
        }
        roots.sort(Comparator.comparing(YkzOrg::getDisplayOrder));
        if (flattenTree) {
            LinkedList<YkzOrg> result = new LinkedList<YkzOrg>();
            YkzUtil.flattenTree(roots, result);
            return result;
        }
        return roots;
    }

    private static void flattenTree(List<YkzOrg> nodes, List<YkzOrg> result) {
        for (YkzOrg node : nodes) {
            result.add(node);
            if (node.getChildren() == null) continue;
            YkzUtil.flattenTree(node.getChildren(), result);
            node.setChildren(null);
        }
    }
}

