/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.service;

import cn.hutool.json.JSONObject;
import com.alibaba.xxpt.gateway.shared.api.request.OapiGettokenJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiRpcOauth2DingtalkAppUserJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.response.OapiGettokenJsonResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiRpcOauth2DingtalkAppUserJsonResponse;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentPostClient;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiSpResultContent;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.JackSonUtil;
import com.efficient.ykz.api.YkzApiService;
import com.efficient.ykz.config.YkzConfig;
import com.efficient.ykz.model.vo.YkzAccessToken;
import com.efficient.ykz.model.vo.YkzLoginUser;
import com.efficient.ykz.properties.YkzApi;
import com.efficient.ykz.properties.YkzProperties;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YkzApiServiceImpl
implements YkzApiService {
    private static final Logger log = LoggerFactory.getLogger(YkzApiServiceImpl.class);
    @Autowired
    private YkzConfig ykzConfig;
    @Autowired
    private YkzProperties ykzProperties;

    @Override
    public Result<YkzAccessToken> accessToken() {
        YkzApi ykzApi = this.ykzProperties.getYkzApi();
        IntelligentGetClient intelligentGetClient = this.ykzConfig.getExecutableClient().newIntelligentGetClient(ykzApi.getAccessToken());
        OapiGettokenJsonRequest oapiGettokenJsonRequest = new OapiGettokenJsonRequest();
        oapiGettokenJsonRequest.setAppkey(ykzApi.getAppkey());
        oapiGettokenJsonRequest.setAppsecret(ykzApi.getAppsecret());
        OapiGettokenJsonResponse apiResult = (OapiGettokenJsonResponse)intelligentGetClient.get((OapiRequest)oapiGettokenJsonRequest);
        if (!apiResult.getSuccess().booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)apiResult.getMessage());
        }
        OapiSpResultContent content = apiResult.getContent();
        Boolean success = content.getSuccess();
        if (!success.booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)content.getResponseMessage());
        }
        String data = content.getData();
        YkzAccessToken accessToken = (YkzAccessToken)JackSonUtil.toObject((String)data, YkzAccessToken.class);
        return Result.ok((Object)accessToken);
    }

    @Override
    public Result<YkzLoginUser> getUserInfo(String authCode) {
        Result<YkzAccessToken> ykzAccessTokenResult = this.accessToken();
        if (!Objects.equals(ykzAccessTokenResult.getCode(), ResultEnum.SUCCESS.getCode())) {
            return Result.build((Integer)ykzAccessTokenResult.getCode(), (String)ykzAccessTokenResult.getMsg());
        }
        YkzApi ykzApi = this.ykzProperties.getYkzApi();
        IntelligentPostClient intelligentPostClient = this.ykzConfig.getExecutableClient().newIntelligentPostClient(ykzApi.getUserInfo());
        OapiRpcOauth2DingtalkAppUserJsonRequest oapiRpcOauth2DingtalkAppUserJsonRequest = new OapiRpcOauth2DingtalkAppUserJsonRequest();
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAccess_token(((YkzAccessToken)ykzAccessTokenResult.getData()).getAccessToken());
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAuth_code(authCode);
        OapiRpcOauth2DingtalkAppUserJsonResponse apiResult = (OapiRpcOauth2DingtalkAppUserJsonResponse)intelligentPostClient.post((OapiRequest)oapiRpcOauth2DingtalkAppUserJsonRequest);
        if (!apiResult.getSuccess().booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)apiResult.getMessage());
        }
        String content = apiResult.getContent();
        JSONObject json = new JSONObject((Object)content);
        JSONObject contentJson = json.getJSONObject((Object)"content");
        boolean success = contentJson.getBool((Object)"success");
        if (!success) {
            return Result.build((Integer)5000, (String)(contentJson.getStr((Object)"responseCode") + ": " + contentJson.getStr((Object)"responseMessage")));
        }
        String userData = contentJson.getStr((Object)"data");
        YkzLoginUser ykzLoginUser = (YkzLoginUser)JackSonUtil.toObject((String)userData, YkzLoginUser.class);
        return Result.ok((Object)ykzLoginUser);
    }
}

