/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.controller;

import com.efficient.common.result.Result;
import com.efficient.ykz.api.YkzApiService;
import com.efficient.ykz.model.dto.msg.YkzSendMsg;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNotice;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNoticeBackOut;
import com.efficient.ykz.model.vo.YkzAccessToken;
import com.efficient.ykz.model.vo.YkzLoginToken;
import com.efficient.ykz.model.vo.YkzLoginUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ykz/api/"})
@Validated
public class YkzApiController {
    @Autowired
    private YkzApiService ykzApiService;

    @GetMapping(value={"/login/accessToken"})
    public Result<YkzAccessToken> accessToken() {
        return this.ykzApiService.accessToken();
    }

    @GetMapping(value={"/login/getUserInfo"})
    public Result<YkzLoginUser> getUserInfo(@RequestParam(value="authCode") String authCode) {
        return this.ykzApiService.getUserInfo(authCode);
    }

    @GetMapping(value={"/login/getTokenInfo"})
    public Result<YkzLoginToken> getTokenInfo(@RequestParam(value="authCode") String authCode) {
        return this.ykzApiService.getTokenInfo(authCode);
    }

    @PostMapping(value={"/msg/send"})
    public Result<String> sendMsg(@RequestBody YkzSendMsg ykzSendMsg) {
        return this.ykzApiService.sendMsg(ykzSendMsg);
    }

    @PostMapping(value={"/workNotice/send"})
    public Result<String> sendWorkNotice(@RequestBody YkzWorkNotice ykzWorkNotice) {
        return this.ykzApiService.sendWorkNotice(ykzWorkNotice);
    }

    @PostMapping(value={"/workNotice/revoke"})
    public Result<String> revokeWorkNotice(@RequestBody YkzWorkNoticeBackOut ykzWorkNotice) {
        return this.ykzApiService.revokeWorkNotice(ykzWorkNotice);
    }
}

