/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.alibaba.xxpt.gateway.shared.api.request.OapiChatSendMsgRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiGettokenJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiMessageRevokeRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiMessageWorkNotificationRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiRpcOauth2DingtalkAppTokenJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiRpcOauth2DingtalkAppUserJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.response.OapiChatSendMsgResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiGettokenJsonResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiMessageRevokeResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiMessageWorkNotificationResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiRpcOauth2DingtalkAppTokenJsonResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiRpcOauth2DingtalkAppUserJsonResponse;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentPostClient;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiSpResultContent;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.JackSonUtil;
import com.efficient.ykz.api.YkzApiService;
import com.efficient.ykz.config.YkzConfig;
import com.efficient.ykz.constant.YkzSendMsgTypeEnum;
import com.efficient.ykz.model.dto.msg.YkzSendMsg;
import com.efficient.ykz.model.dto.msg.YkzSendMsgFile;
import com.efficient.ykz.model.dto.msg.YkzSendMsgImage;
import com.efficient.ykz.model.dto.msg.YkzSendMsgLink;
import com.efficient.ykz.model.dto.msg.YkzSendMsgText;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNotice;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNoticeBackOut;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNoticeMsgLink;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNoticeMsgMarkdown;
import com.efficient.ykz.model.dto.worknotice.YkzWorkNoticeMsgText;
import com.efficient.ykz.model.vo.YkzAccessToken;
import com.efficient.ykz.model.vo.YkzLoginToken;
import com.efficient.ykz.model.vo.YkzLoginUser;
import com.efficient.ykz.properties.YkzApi;
import com.efficient.ykz.properties.YkzProperties;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YkzApiServiceImpl
implements YkzApiService {
    private static final Logger log = LoggerFactory.getLogger(YkzApiServiceImpl.class);
    @Autowired
    private YkzConfig ykzConfig;
    @Autowired
    private YkzProperties ykzProperties;

    private <T> Result<T> getApiResult(String content, Class<T> tClass) {
        JSONObject json = new JSONObject((Object)content);
        boolean success = json.getBool((Object)"success");
        if (!success) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)(json.getStr((Object)"errorCode") + ": " + json.getStr((Object)"errorMsg")));
        }
        JSONObject contentJson = json.getJSONObject((Object)"content");
        Boolean success2 = contentJson.getBool((Object)"success");
        if (Objects.nonNull(success2) && !success2.booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)(contentJson.getStr((Object)"responseCode") + ": " + contentJson.getStr((Object)"responseMessage")));
        }
        String data = contentJson.getStr((Object)"data");
        if (StrUtil.isBlank((CharSequence)data)) {
            data = contentJson.getStr((Object)"msgId");
        }
        return Result.ok((Object)JackSonUtil.toObject((String)data, tClass));
    }

    @Override
    public Result<YkzAccessToken> accessToken() {
        YkzApi ykzApi = this.ykzProperties.getYkzApi();
        IntelligentGetClient intelligentGetClient = this.ykzConfig.getExecutableClient().newIntelligentGetClient(ykzApi.getAccessToken());
        OapiGettokenJsonRequest oapiGettokenJsonRequest = new OapiGettokenJsonRequest();
        oapiGettokenJsonRequest.setAppkey(ykzApi.getAppkey());
        oapiGettokenJsonRequest.setAppsecret(ykzApi.getAppsecret());
        OapiGettokenJsonResponse apiResult = (OapiGettokenJsonResponse)intelligentGetClient.get((OapiRequest)oapiGettokenJsonRequest);
        log.info("accessToken \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)JackSonUtil.toJson((Object)apiResult));
        if (!apiResult.getSuccess().booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)apiResult.getMessage());
        }
        OapiSpResultContent content = apiResult.getContent();
        Boolean success = content.getSuccess();
        if (!success.booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)content.getResponseMessage());
        }
        String data = content.getData();
        YkzAccessToken accessToken = (YkzAccessToken)JackSonUtil.toObject((String)data, YkzAccessToken.class);
        return Result.ok((Object)accessToken);
    }

    @Override
    public Result<YkzLoginUser> getUserInfo(String authCode) {
        Result<YkzAccessToken> ykzAccessTokenResult = this.accessToken();
        if (!Objects.equals(ykzAccessTokenResult.getCode(), ResultEnum.SUCCESS.getCode())) {
            return Result.build((Integer)ykzAccessTokenResult.getCode(), (String)ykzAccessTokenResult.getMsg());
        }
        YkzApi ykzApi = this.ykzProperties.getYkzApi();
        IntelligentPostClient intelligentPostClient = this.ykzConfig.getExecutableClient().newIntelligentPostClient(ykzApi.getUserInfo());
        OapiRpcOauth2DingtalkAppUserJsonRequest oapiRpcOauth2DingtalkAppUserJsonRequest = new OapiRpcOauth2DingtalkAppUserJsonRequest();
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAccess_token(((YkzAccessToken)ykzAccessTokenResult.getData()).getAccessToken());
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAuth_code(authCode);
        OapiRpcOauth2DingtalkAppUserJsonResponse apiResult = (OapiRpcOauth2DingtalkAppUserJsonResponse)intelligentPostClient.post((OapiRequest)oapiRpcOauth2DingtalkAppUserJsonRequest);
        log.info("getUserInfo \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)JackSonUtil.toJson((Object)apiResult));
        if (!apiResult.getSuccess().booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)apiResult.getMessage());
        }
        String content = apiResult.getContent();
        return this.getApiResult(content, YkzLoginUser.class);
    }

    @Override
    public Result<YkzLoginToken> getTokenInfo(String authCode) {
        Result<YkzAccessToken> ykzAccessTokenResult = this.accessToken();
        if (!Objects.equals(ykzAccessTokenResult.getCode(), ResultEnum.SUCCESS.getCode())) {
            return Result.build((Integer)ykzAccessTokenResult.getCode(), (String)ykzAccessTokenResult.getMsg());
        }
        IntelligentPostClient intelligentPostClient = this.ykzConfig.getExecutableClient().newIntelligentPostClient(this.ykzProperties.getYkzApi().getTokenInfo());
        OapiRpcOauth2DingtalkAppTokenJsonRequest oapiRpcOauth2DingtalkAppTokenJsonRequest = new OapiRpcOauth2DingtalkAppTokenJsonRequest();
        oapiRpcOauth2DingtalkAppTokenJsonRequest.setAccess_token(((YkzAccessToken)ykzAccessTokenResult.getData()).getAccessToken());
        oapiRpcOauth2DingtalkAppTokenJsonRequest.setAuth_code(authCode);
        OapiRpcOauth2DingtalkAppTokenJsonResponse apiResult = (OapiRpcOauth2DingtalkAppTokenJsonResponse)intelligentPostClient.post((OapiRequest)oapiRpcOauth2DingtalkAppTokenJsonRequest);
        log.info("getTokenInfo \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)JackSonUtil.toJson((Object)apiResult));
        if (!apiResult.getSuccess().booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)apiResult.getMessage());
        }
        String content = apiResult.getContent();
        return this.getApiResult(content, YkzLoginToken.class);
    }

    @Override
    public Result<String> sendMsg(YkzSendMsg ykzSendMsg) {
        IntelligentGetClient intelligentGetClient = this.ykzConfig.getExecutableClient().newIntelligentGetClient(this.ykzProperties.getYkzApi().getSendMsg());
        OapiChatSendMsgRequest oapiChatSendMsgRequest = new OapiChatSendMsgRequest();
        String msg = "";
        switch (ykzSendMsg.getMsgType()) {
            case TEXT: {
                YkzSendMsgText sendMsgText = ykzSendMsg.getTextDetail();
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("msgtype", (Object)YkzSendMsgTypeEnum.TEXT.getType());
                jsonObject.set("text", (Object)new JSONObject().set("content", (Object)sendMsgText.getContent()));
                msg = jsonObject.toString();
                break;
            }
            case LINK: {
                YkzSendMsgLink sendMsgLink = ykzSendMsg.getLinkDetail();
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("msgtype", (Object)YkzSendMsgTypeEnum.LINK.getType());
                jsonObject.set("link", (Object)new JSONObject().set("title", (Object)sendMsgLink.getTitle()).set("messageUrl", (Object)sendMsgLink.getMessageUrl()).set("text", (Object)sendMsgLink.getText()).set("picMediaId", (Object)sendMsgLink.getPicMediaId()).set("sourceUrl", (Object)sendMsgLink.getSourceUrl()));
                msg = jsonObject.toString();
                break;
            }
            case IMAGE: {
                YkzSendMsgImage sendMsgImage = ykzSendMsg.getImageDetail();
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("msgtype", (Object)YkzSendMsgTypeEnum.IMAGE.getType());
                jsonObject.set("image", (Object)new JSONObject().set("mediaId", (Object)sendMsgImage.getMediaId()).set("fileType", (Object)sendMsgImage.getFileType()));
                msg = jsonObject.toString();
                break;
            }
            case FILE: {
                YkzSendMsgFile sendMsgFile = ykzSendMsg.getFileDetail();
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("msgtype", (Object)YkzSendMsgTypeEnum.FILE.getType());
                jsonObject.set("previewFile", (Object)new JSONObject().set("mediaId", (Object)sendMsgFile.getMediaId()).set("size", (Object)sendMsgFile.getSize()).set("size", (Object)sendMsgFile.getSize()).set("name", (Object)sendMsgFile.getName()).set("fileType", (Object)sendMsgFile.getFileType()));
                msg = jsonObject.toString();
            }
        }
        oapiChatSendMsgRequest.setMsg(msg);
        oapiChatSendMsgRequest.setSenderId(ykzSendMsg.getSenderId());
        oapiChatSendMsgRequest.setReceiverId(ykzSendMsg.getReceiverId());
        oapiChatSendMsgRequest.setChatId(ykzSendMsg.getChatId());
        oapiChatSendMsgRequest.setTenantId(this.ykzProperties.getYkzApi().getTenantId());
        oapiChatSendMsgRequest.setChatType(ykzSendMsg.getChatType());
        OapiChatSendMsgResponse apiResult = (OapiChatSendMsgResponse)intelligentGetClient.get((OapiRequest)oapiChatSendMsgRequest);
        log.info("sendMsg \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)JackSonUtil.toJson((Object)apiResult));
        if (!apiResult.getSuccess().booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)apiResult.getMessage());
        }
        String data = apiResult.getContent().getData();
        JSONObject json = new JSONObject((Object)data);
        String contentJson = json.getStr((Object)"messageId");
        return Result.ok((Object)contentJson);
    }

    @Override
    public Result<String> sendWorkNotice(YkzWorkNotice ykzWorkNotice) {
        IntelligentGetClient intelligentGetClient = this.ykzConfig.getExecutableClient().newIntelligentGetClient(this.ykzProperties.getYkzApi().getSendWorkNotice());
        OapiMessageWorkNotificationRequest oapiMessageWorkNotificationRequest = new OapiMessageWorkNotificationRequest();
        oapiMessageWorkNotificationRequest.setOrganizationCodes(ykzWorkNotice.getOrganizationCodes());
        oapiMessageWorkNotificationRequest.setReceiverIds(ykzWorkNotice.getReceiverIds());
        oapiMessageWorkNotificationRequest.setTenantId(String.valueOf(this.ykzProperties.getYkzApi().getTenantId()));
        oapiMessageWorkNotificationRequest.setBizMsgId(ykzWorkNotice.getBizMsgId());
        String msg = ykzWorkNotice.getMsg();
        YkzSendMsgTypeEnum msgType = ykzWorkNotice.getMsgType();
        switch (msgType) {
            case TEXT: {
                YkzWorkNoticeMsgText workNoticeMsgText = ykzWorkNotice.getMsgText();
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("msgtype", (Object)YkzSendMsgTypeEnum.TEXT.getType());
                jsonObject.set(YkzSendMsgTypeEnum.TEXT.getType(), (Object)new JSONObject().set("content", (Object)workNoticeMsgText.getContent()));
                msg = jsonObject.toString();
                break;
            }
            case LINK: {
                YkzWorkNoticeMsgLink workNoticeMsgLink = ykzWorkNotice.getMsgLink();
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("msgtype", (Object)YkzSendMsgTypeEnum.LINK.getType());
                jsonObject.set(YkzSendMsgTypeEnum.LINK.getType(), (Object)new JSONObject().set("messageUrl", (Object)workNoticeMsgLink.getMessageUrl()).set("picUrl", (Object)workNoticeMsgLink.getPicUrl()).set("title", (Object)workNoticeMsgLink.getTitle()).set("text", (Object)workNoticeMsgLink.getText()));
                msg = jsonObject.toString();
                break;
            }
            case MARKDOWN: {
                YkzWorkNoticeMsgMarkdown workNoticeMsgMarkdown = ykzWorkNotice.getMsgMarkdown();
                JSONObject jsonObject = new JSONObject();
                jsonObject.set("msgtype", (Object)YkzSendMsgTypeEnum.LINK.getType());
                jsonObject.set(YkzSendMsgTypeEnum.LINK.getType(), (Object)new JSONObject().set("title", (Object)workNoticeMsgMarkdown.getTitle()).set("text", (Object)workNoticeMsgMarkdown.getText()));
                msg = jsonObject.toString();
            }
        }
        oapiMessageWorkNotificationRequest.setMsg(msg);
        OapiMessageWorkNotificationResponse apiResult = (OapiMessageWorkNotificationResponse)intelligentGetClient.get((OapiRequest)oapiMessageWorkNotificationRequest);
        log.info("sendWorkNotice \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)JackSonUtil.toJson((Object)apiResult));
        String content = apiResult.getContent();
        return this.getApiResult(content, String.class);
    }

    @Override
    public Result<String> revokeWorkNotice(YkzWorkNoticeBackOut ykzWorkNotice) {
        IntelligentGetClient intelligentGetClient = this.ykzConfig.getExecutableClient().newIntelligentGetClient(this.ykzProperties.getYkzApi().getRevokeWorkNotice());
        OapiMessageRevokeRequest oapiMessageRevokeRequest = new OapiMessageRevokeRequest();
        oapiMessageRevokeRequest.setMsgType(ykzWorkNotice.getMsgType());
        oapiMessageRevokeRequest.setMsgApp(ykzWorkNotice.getMsgApp());
        oapiMessageRevokeRequest.setTenantId(String.valueOf(this.ykzProperties.getYkzApi().getTenantId()));
        oapiMessageRevokeRequest.setBizMsgId(ykzWorkNotice.getBizMsgId());
        OapiMessageRevokeResponse apiResult = (OapiMessageRevokeResponse)intelligentGetClient.get((OapiRequest)oapiMessageRevokeRequest);
        log.info("revokeWorkNotice \u7ed3\u679c\u6570\u636e\uff1a {}", (Object)JackSonUtil.toJson((Object)apiResult));
        if (!apiResult.getSuccess().booleanValue()) {
            return Result.build((Integer)ResultEnum.FAILED.getCode(), (String)apiResult.getMessage());
        }
        String data = apiResult.getContent().getData();
        return StrUtil.equalsIgnoreCase((CharSequence)"true", (CharSequence)data) ? Result.ok() : Result.fail();
    }
}

