/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.ykz.controller;

import com.dcqc.uc.oauth.sdk.model.Request;
import com.dcqc.uc.oauth.sdk.model.Result;
import com.dcqc.uc.oauth.sdk.model.v3.SynchronizeV3DTO;
import com.efficient.common.permission.Permission;
import com.efficient.ykz.api.YkzUserCenterHandleService;
import com.efficient.ykz.api.YkzUserCenterService;
import com.efficient.ykz.api.YkzUserCenterSyncService;
import com.efficient.ykz.model.vo.YkzLabel;
import com.efficient.ykz.model.vo.YkzOrg;
import com.efficient.ykz.model.vo.YkzUser;
import com.efficient.ykz.model.vo.YkzUserPost;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ykz/userCenter/"})
@Validated
@Api(tags={"YKZ -\u7528\u6237\u4e2d\u5fc3"})
@Permission
public class YkzUserCenterController {
    private static final Logger log = LoggerFactory.getLogger(YkzUserCenterController.class);
    @Autowired
    private YkzUserCenterService ykzUserCenterService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private YkzUserCenterHandleService handleService;

    @GetMapping(value={"/org/orgByCode"})
    @ApiOperation(value="\u6839\u636e\u673a\u6784Code\u62c9\u53d6\u673a\u6784", response=YkzOrg.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgCode", value="\u62c9\u53d6\u9876\u7ea7\u673a\u6784organizationCode\u6b63\u5f0f\u73af\u5883\u4f20575324d0-2257-4f53-8e5f-ca72d992abe9\uff0c\u6d4b\u8bd5\u73af\u5883\u4f20GO_1065d20ebe964b4d9da264cfe5e5d240", required=true)})
    public com.efficient.common.result.Result<YkzOrg> orgByCode(@NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="orgCode") @NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") String orgCode) throws Exception {
        com.efficient.common.result.Result<YkzOrg> result = this.ykzUserCenterService.orgByCode(orgCode);
        if (Objects.equals(result.getCode(), com.efficient.common.result.Result.ok().getCode())) {
            log.info("\u5f00\u59cb\u5904\u7406\u5165\u5e93\u903b\u8f91");
            return this.handleService.handleOrgByCode((YkzOrg)result.getData());
        }
        return result;
    }

    @PostMapping(value={"/org/orgByCodeList"})
    @ApiOperation(value="\u6839\u636e\u673a\u6784Code\u6279\u91cf\u62c9\u53d6\u673a\u6784", response=YkzOrg.class)
    public com.efficient.common.result.Result<List<YkzOrg>> orgByCodeList(@RequestBody List<String> orgCodeList) throws Exception {
        com.efficient.common.result.Result<List<YkzOrg>> result = this.ykzUserCenterService.orgByCodeList(orgCodeList);
        if (Objects.equals(result.getCode(), com.efficient.common.result.Result.ok().getCode())) {
            log.info("\u5f00\u59cb\u5904\u7406\u5165\u5e93\u903b\u8f91");
            return this.handleService.handleOrgByCodeList((List)result.getData());
        }
        return result;
    }

    @GetMapping(value={"/org/orgByParentCode"})
    @ApiOperation(value="\u6839\u636e\u673a\u6784Code\u62c9\u53d6\u673a\u6784", response=YkzOrg.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgCode", value="YKZ orgCode", required=true), @ApiImplicitParam(name="pageNum", value="pageNum", required=true), @ApiImplicitParam(name="pageSize", value="pageSize \u6700\u5927 100", required=true), @ApiImplicitParam(name="includeTop", value="\u662f\u5426\u5305\u542b\u5f53\u524d\u673a\u6784", required=false, defaultValue="true"), @ApiImplicitParam(name="flattenTree", value="\u662f\u5426\u6241\u5e73\u5316\u673a\u6784", required=false, defaultValue="false")})
    public com.efficient.common.result.Result<List<YkzOrg>> orgByParentCode(@NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="orgCode") @NotBlank(message="orgCode \u4e0d\u80fd\u4e3a\u7a7a") String orgCode, @NotNull(message="pageNum \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="pageNum") @NotNull(message="pageNum \u4e0d\u80fd\u4e3a\u7a7a") Integer pageNum, @NotNull(message="pageSize \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="pageSize") @NotNull(message="pageSize \u4e0d\u80fd\u4e3a\u7a7a") Integer pageSize, @RequestParam(name="includeTop", required=false, defaultValue="true") boolean includeTop, @RequestParam(name="flattenTree", required=false, defaultValue="false") boolean flattenTree) throws Exception {
        com.efficient.common.result.Result<List<YkzOrg>> result;
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (pageSize < 20) {
            pageSize = 20;
        }
        if (Objects.equals((result = this.ykzUserCenterService.orgByParentCode(orgCode, pageNum, pageSize, includeTop, flattenTree)).getCode(), com.efficient.common.result.Result.ok().getCode())) {
            log.info("\u5f00\u59cb\u5904\u7406\u5165\u5e93\u903b\u8f91");
            return this.handleService.handleOrgByParentCode(orgCode, includeTop, flattenTree, (List)result.getData());
        }
        return result;
    }

    @GetMapping(value={"/user/userByMobile"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f", response=YkzUser.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7", required=true)})
    public com.efficient.common.result.Result<YkzUser> userByMobile(@NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="phone") @NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") String phone) throws Exception {
        com.efficient.common.result.Result<YkzUser> result = this.ykzUserCenterService.userByMobile(phone);
        if (Objects.equals(result.getCode(), com.efficient.common.result.Result.ok().getCode())) {
            log.info("\u5f00\u59cb\u5904\u7406\u5165\u5e93\u903b\u8f91");
            return this.handleService.handleUserByMobile((YkzUser)result.getData());
        }
        return result;
    }

    @PostMapping(value={"/user/userByMobileList"})
    @ApiOperation(value="\u6279\u91cf\u6839\u636e\u7528\u6237\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f", response=YkzUser.class)
    public com.efficient.common.result.Result<List<YkzUser>> userByMobileList(@RequestBody List<String> phoneList) throws Exception {
        com.efficient.common.result.Result<List<YkzUser>> result = this.ykzUserCenterService.userByMobileList(phoneList);
        if (Objects.equals(result.getCode(), com.efficient.common.result.Result.ok().getCode())) {
            log.info("\u5f00\u59cb\u5904\u7406\u5165\u5e93\u903b\u8f91");
            return this.handleService.handleUserByMobileList((List)result.getData());
        }
        return result;
    }

    @GetMapping(value={"/user/userByZwddId"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u653f\u9489ID\u67e5\u8be2\u7528\u6237\u4fe1\u606f", response=YkzUser.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="zwddId", value="\u653f\u52a1\u9489\u9489ID", required=true)})
    public com.efficient.common.result.Result<YkzUser> userByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        com.efficient.common.result.Result<YkzUser> result = this.ykzUserCenterService.userByZwddId(zwddId);
        if (Objects.equals(result.getCode(), com.efficient.common.result.Result.ok().getCode())) {
            log.info("\u5f00\u59cb\u5904\u7406\u5165\u5e93\u903b\u8f91");
            return this.handleService.handleUserByZwddId((YkzUser)result.getData());
        }
        return result;
    }

    @PostMapping(value={"/user/userByZwddIdList"})
    @ApiOperation(value="\u6279\u91cf\u6839\u636e\u7528\u6237\u653f\u9489ID\u67e5\u8be2\u7528\u6237\u4fe1\u606f", response=YkzUser.class)
    public com.efficient.common.result.Result<List<YkzUser>> userByZwddIdList(@RequestBody List<String> zwddIdList) throws Exception {
        com.efficient.common.result.Result<List<YkzUser>> result = this.ykzUserCenterService.userByZwddIdList(zwddIdList);
        if (Objects.equals(result.getCode(), com.efficient.common.result.Result.ok().getCode())) {
            log.info("\u5f00\u59cb\u5904\u7406\u5165\u5e93\u903b\u8f91");
            return this.handleService.handleUserByZwddIdList((List)result.getData());
        }
        return result;
    }

    @GetMapping(value={"/userPost/userPostByZwddId"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u653f\u9489ID\u67e5\u8be2\u7528\u6237\u4fe1\u606f", response=YkzOrg.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="zwddId", value="\u653f\u52a1\u9489\u9489ID", required=true)})
    public com.efficient.common.result.Result<List<YkzUserPost>> userPostByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        com.efficient.common.result.Result<List<YkzUserPost>> result = this.ykzUserCenterService.userPostByZwddId(zwddId);
        if (Objects.equals(result.getCode(), com.efficient.common.result.Result.ok().getCode())) {
            log.info("\u5f00\u59cb\u5904\u7406\u5165\u5e93\u903b\u8f91");
            return this.handleService.handleUserPostByZwddId((List)result.getData());
        }
        return result;
    }

    @GetMapping(value={"/userTag/userTagByZwddId"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u653f\u9489Id\u67e5\u8be2\u7528\u6237\u6807\u7b7e\u4fe1\u606f", response=YkzLabel.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="zwddId", value="\u653f\u52a1\u9489\u9489ID", required=true)})
    public com.efficient.common.result.Result<YkzLabel> userTagByZwddId(@NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="zwddId") @NotBlank(message="zwddId \u4e0d\u80fd\u4e3a\u7a7a") String zwddId) throws Exception {
        return this.ykzUserCenterService.userTagByZwddId(zwddId);
    }

    @GetMapping(value={"/userTag/userTagByMobile"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u6807\u7b7e\u4fe1\u606f", response=YkzLabel.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7", required=true)})
    public com.efficient.common.result.Result<YkzLabel> userTagByMobile(@NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="phone") @NotBlank(message="phone \u4e0d\u80fd\u4e3a\u7a7a") String phone) throws Exception {
        return this.ykzUserCenterService.userTagByMobile(phone);
    }

    @PostMapping(value={"/userTag/userTagByZwddIdList"})
    @ApiOperation(value="\u6279\u91cf\u6839\u636e\u7528\u6237\u653f\u9489Id\u67e5\u8be2\u7528\u6237\u6807\u7b7e\u4fe1\u606f", response=YkzLabel.class)
    public com.efficient.common.result.Result<List<YkzLabel>> userTagByZwddIdList(@RequestBody List<String> zwddIdList) throws Exception {
        return this.ykzUserCenterService.userTagByZwddIdList(zwddIdList);
    }

    @PostMapping(value={"/userTag/userTagByMobileList"})
    @ApiOperation(value="\u6279\u91cf\u6839\u636e\u7528\u6237\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u6807\u7b7e\u4fe1\u606f", response=YkzLabel.class)
    public com.efficient.common.result.Result<List<YkzLabel>> userTagByMobileList(@RequestBody List<String> phoneList) throws Exception {
        return this.ykzUserCenterService.userTagByMobileList(phoneList);
    }

    @PostMapping(value={"/ykz/sync"})
    @ApiOperation(value="\u5355\u4e2a\u7ec4\u7ec7\u7528\u6237\u589e\u91cf\u540c\u6b65\u63a5\u53e3", response=Boolean.class)
    public Result<Boolean> ykzSync(@RequestBody @Validated Request<SynchronizeV3DTO> request) {
        Result objectResult = new Result();
        try {
            SynchronizeV3DTO synchronizeV3DTO = (SynchronizeV3DTO)request.getData();
            YkzUserCenterSyncService userCenterSyncService = (YkzUserCenterSyncService)this.applicationContext.getBean(YkzUserCenterSyncService.class);
            userCenterSyncService.ykzSync(synchronizeV3DTO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            objectResult.setFailed(e.getMessage());
        }
        return objectResult;
    }
}

