/*
 * Decompiled with CFR 0.152.
 */
package com.sjr.common.util;

import cn.hutool.core.util.StrUtil;
import com.sjr.common.entity.TreeNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TreeUtil {
    private static final Long LAST_ORDER = 9999L;
    public static final String[] NXS_STR = new String[]{"a", "b", "c", "d"};

    public static List<TreeNode> createListTree(List<TreeNode> nodeList) {
        List rootNodes = nodeList.stream().filter(node -> Objects.nonNull(node.getIsRoot()) && node.getIsRoot() != false).collect(Collectors.toList());
        ArrayList<TreeNode> resultList = new ArrayList<TreeNode>(4);
        for (TreeNode rootNode : rootNodes) {
            if (Objects.isNull(rootNode.getOrder())) {
                rootNode.setOrder(LAST_ORDER);
            }
            TreeUtil.createChildren(rootNode, nodeList);
            resultList.add(rootNode);
        }
        return resultList.stream().sorted(Comparator.comparing(TreeNode::getOrder)).collect(Collectors.toList());
    }

    public static TreeNode createChildren(TreeNode parentNode, List<TreeNode> nodeList) {
        ArrayList<TreeNode> childrenList = new ArrayList<TreeNode>();
        for (TreeNode treeNode : nodeList) {
            if (!StrUtil.equals((CharSequence)treeNode.getParentCode(), (CharSequence)parentNode.getCode())) continue;
            childrenList.add(TreeUtil.createChildren(treeNode, nodeList));
        }
        List<TreeNode> collect = childrenList.stream().sorted(Comparator.comparing(TreeNode::getOrder)).collect(Collectors.toList());
        parentNode.setIsLeaf(collect.size() == 0);
        parentNode.setChildren(collect);
        return parentNode;
    }

    public static TreeNode createTree(List<TreeNode> nodeList) {
        List<TreeNode> listTree = TreeUtil.createListTree(nodeList);
        return listTree.get(0);
    }
}

