/*
 * Decompiled with CFR 0.152.
 */
package com.sjr.common.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);

    public static String getIP(HttpServletRequest request) {
        try {
            Assert.notNull((Object)request, (String)"HttpServletRequest is null", (Object[])new Object[0]);
            String ip = request.getHeader("X-Requested-For");
            if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("X-Forwarded-For");
            }
            if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
            return StrUtil.isBlank((CharSequence)ip) ? null : ip.split(",")[0];
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6IP\u5730\u5740\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }
}

