/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.generator;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import top.tanmw.generator.CodeGenerateUtils;
import top.tanmw.generator.GeneratorModel;
import top.tanmw.generator.ProjectPattern;

public class Generator {
    public static void main(String[] args) throws Exception {
        String url = Generator.class.getClassLoader().getResource("generator.txt").getPath().toString();
        Generator.run(url);
    }

    public static void run(String url) throws Exception {
        Properties properties = Generator.getProperties(url);
        GeneratorModel model = new GeneratorModel();
        model.setUrl(properties.getProperty("url"));
        model.setDriver(properties.getProperty("driver"));
        model.setUser(properties.getProperty("user"));
        model.setPassword(properties.getProperty("password"));
        model.setDbName(properties.getProperty("dbName"));
        model.setShowTablesSql(properties.getProperty("showTablesSql"));
        model.setShowTablesCommentSql(properties.getProperty("showTablesCommentSql"));
        model.setBasePath(properties.getProperty("basePath"));
        if (StrUtil.isBlank((CharSequence)model.getBasePath())) {
            String sp1 = System.getProperty("user.dir");
            model.setBasePath(sp1);
        }
        model.setDelete(properties.getProperty("isDelete"));
        model.setDeleteLevel(properties.getProperty("deleteLevel"));
        model.setModuleName(properties.getProperty("moduleName"));
        if (StrUtil.isBlank((CharSequence)model.getModuleName())) {
            String basePath = model.getBasePath();
            File file = new File(basePath);
            String name = file.getName();
            model.setModuleName(name);
        }
        model.setPackageName(properties.getProperty("packageName"));
        if (StrUtil.isBlank((CharSequence)model.getPackageName())) {
            model.setPackageName(model.getModuleName());
        }
        model.setPattern(properties.getProperty("pattern"));
        if (StrUtil.isBlank((CharSequence)model.getPattern())) {
            model.setPattern(ProjectPattern.MULTI.getDesc());
        }
        model.setExcludePrefix(properties.getProperty("excludePrefix"));
        model.setIncludeSet(properties.getProperty("includeSet"));
        model.setExcludeSet(properties.getProperty("excludeSet"));
        model.setReplace(false);
        if (StrUtil.isNotBlank((CharSequence)properties.getProperty("replace"))) {
            model.setReplace(Boolean.parseBoolean(properties.getProperty("replace")));
        }
        String fileType = properties.getProperty("fileType");
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (StrUtil.isBlank((CharSequence)fileType)) {
            for (int i = 0; i < 20; ++i) {
                list.add(i);
            }
        } else {
            String[] split;
            for (String str : split = fileType.split(",")) {
                if (!str.contains("-") && NumberUtil.isNumber((CharSequence)str)) {
                    list.add(Integer.parseInt(str));
                    continue;
                }
                String[] split1 = str.split("-");
                if (split1.length != 2 || !NumberUtil.isNumber((CharSequence)split1[0]) || !NumberUtil.isNumber((CharSequence)split1[1])) continue;
                for (int y = Integer.parseInt(split1[0]); y <= Integer.parseInt(split1[1]); ++y) {
                    list.add(y);
                }
            }
        }
        model.setFileType(list);
        CodeGenerateUtils codeGenerateUtils = new CodeGenerateUtils();
        codeGenerateUtils.init(model);
        codeGenerateUtils.generate();
    }

    public static Properties getProperties(String url) throws Exception {
        Properties properties = new Properties();
        File file = new File(url);
        FileInputStream in = new FileInputStream(file);
        properties.load(in);
        return properties;
    }
}

