/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] EXP_CHARS = new char[]{'.', '[', ']'};
    private boolean isStartWith = false;
    protected List<String> patternParts;

    public static BeanPath create(String expression) {
        return new BeanPath(expression);
    }

    public BeanPath(String expression) {
        this.init(expression);
    }

    public Object get(Object bean) {
        return this.get(this.patternParts, bean, false);
    }

    public void set(Object bean, Object value) {
        this.set(bean, this.patternParts, value);
    }

    private void set(Object bean, List<String> patternParts, Object value) {
        Object subBean = this.get(patternParts, bean, true);
        if (null == subBean) {
            this.set(bean, patternParts.subList(0, patternParts.size() - 1), new HashMap());
            subBean = this.get(patternParts, bean, true);
        }
        BeanUtil.setFieldValue(subBean, patternParts.get(patternParts.size() - 1), value);
    }

    private Object get(List<String> patternParts, Object bean, boolean ignoreLast) {
        int length = patternParts.size();
        if (ignoreLast) {
            --length;
        }
        Object subBean = bean;
        boolean isFirst = true;
        for (int i2 = 0; i2 < length; ++i2) {
            String patternPart = patternParts.get(i2);
            if (null != (subBean = BeanPath.getFieldValue(subBean, patternPart))) continue;
            if (isFirst && !this.isStartWith && BeanUtil.isMatchName(bean, patternPart, true)) {
                subBean = bean;
                isFirst = false;
                continue;
            }
            return null;
        }
        return subBean;
    }

    private static Object getFieldValue(Object bean, String expression) {
        if (StrUtil.isBlank(expression)) {
            return null;
        }
        if (StrUtil.contains((CharSequence)expression, ':')) {
            List<String> parts = StrUtil.splitTrim((CharSequence)expression, ':');
            int start = Integer.parseInt(parts.get(0));
            int end = Integer.parseInt(parts.get(1));
            int step = 1;
            if (3 == parts.size()) {
                step = Integer.parseInt(parts.get(2));
            }
            if (bean instanceof Collection) {
                return CollUtil.sub((Collection)bean, start, end, step);
            }
            if (ArrayUtil.isArray(bean)) {
                return ArrayUtil.sub(bean, start, end, step);
            }
        } else {
            if (StrUtil.contains((CharSequence)expression, ',')) {
                List<String> keys = StrUtil.splitTrim((CharSequence)expression, ',');
                if (bean instanceof Collection) {
                    return CollUtil.getAny((Collection)bean, Convert.convert(int[].class, keys));
                }
                if (ArrayUtil.isArray(bean)) {
                    return ArrayUtil.getAny(bean, Convert.convert(int[].class, keys));
                }
                String[] unWrappedKeys = new String[keys.size()];
                for (int i2 = 0; i2 < unWrappedKeys.length; ++i2) {
                    unWrappedKeys[i2] = StrUtil.unWrap(keys.get(i2), '\'');
                }
                if (bean instanceof Map) {
                    return MapUtil.getAny((Map)bean, unWrappedKeys);
                }
                Map<String, Object> map = BeanUtil.beanToMap(bean);
                return MapUtil.getAny(map, unWrappedKeys);
            }
            return BeanUtil.getFieldValue(bean, expression);
        }
        return null;
    }

    private void init(String expression) {
        ArrayList<String> localPatternParts = new ArrayList<String>();
        int length = expression.length();
        StrBuilder builder = StrUtil.strBuilder();
        boolean isNumStart = false;
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = expression.charAt(i2);
            if (0 == i2 && '$' == c2) {
                this.isStartWith = true;
                continue;
            }
            if (ArrayUtil.contains(EXP_CHARS, c2)) {
                if (']' == c2) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find ']' but no '[' !", expression, i2));
                    }
                    isNumStart = false;
                } else {
                    if (isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, i2));
                    }
                    if ('[' == c2) {
                        isNumStart = true;
                    }
                }
                if (builder.length() > 0) {
                    localPatternParts.add(BeanPath.unWrapIfPossible(builder));
                }
                builder.reset();
                continue;
            }
            builder.append(c2);
        }
        if (isNumStart) {
            throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, length - 1));
        }
        if (builder.length() > 0) {
            localPatternParts.add(BeanPath.unWrapIfPossible(builder));
        }
        this.patternParts = Collections.unmodifiableList(localPatternParts);
    }

    private static String unWrapIfPossible(CharSequence expression) {
        if (StrUtil.containsAny(expression, " = ", " > ", " < ", " like ", ",")) {
            return expression.toString();
        }
        return StrUtil.unWrap(expression, '\'');
    }
}

