/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

public class Caesar {
    public static final String TABLE = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";

    public static String encode(String message, int offset) {
        int len = message.length();
        char[] plain = message.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = message.charAt(i2);
            if (!Character.isLetter(c2)) continue;
            plain[i2] = Caesar.encodeChar(c2, offset);
        }
        return new String(plain);
    }

    public static String decode(String cipherText, int offset) {
        int len = cipherText.length();
        char[] plain = cipherText.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = cipherText.charAt(i2);
            if (!Character.isLetter(c2)) continue;
            plain[i2] = Caesar.decodeChar(c2, offset);
        }
        return new String(plain);
    }

    private static char encodeChar(char c2, int offset) {
        int position = (TABLE.indexOf(c2) + offset) % 52;
        return TABLE.charAt(position);
    }

    private static char decodeChar(char c2, int offset) {
        int position = (TABLE.indexOf(c2) - offset) % 52;
        if (position < 0) {
            position += 52;
        }
        return TABLE.charAt(position);
    }
}

