/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;

public class PunyCode {
    private static final int TMIN = 1;
    private static final int TMAX = 26;
    private static final int BASE = 36;
    private static final int INITIAL_N = 128;
    private static final int INITIAL_BIAS = 72;
    private static final int DAMP = 700;
    private static final int SKEW = 38;
    private static final char DELIMITER = '-';
    public static final String PUNY_CODE_PREFIX = "xn--";

    public static String encode(String input) throws UtilException {
        return PunyCode.encode(input, false);
    }

    public static String encode(String input, boolean withPrefix) throws UtilException {
        int n2 = 128;
        int delta = 0;
        int bias = 72;
        StringBuilder output = new StringBuilder();
        int length = input.length();
        int b2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = input.charAt(i2);
            if (!PunyCode.isBasic(c2)) continue;
            output.append(c2);
            ++b2;
        }
        if (b2 > 0) {
            output.append('-');
        }
        int h2 = b2;
        while (h2 < length) {
            int c3;
            int m3 = Integer.MAX_VALUE;
            for (int i3 = 0; i3 < length; ++i3) {
                c3 = input.charAt(i3);
                if (c3 < n2 || c3 >= m3) continue;
                m3 = c3;
            }
            if (m3 - n2 > (Integer.MAX_VALUE - delta) / (h2 + 1)) {
                throw new UtilException("OVERFLOW");
            }
            delta += (m3 - n2) * (h2 + 1);
            n2 = m3;
            for (int j2 = 0; j2 < length; ++j2) {
                int t2;
                c3 = input.charAt(j2);
                if (c3 < n2 && 0 == ++delta) {
                    throw new UtilException("OVERFLOW");
                }
                if (c3 != n2) continue;
                int q2 = delta;
                int k2 = 36;
                while (q2 >= (t2 = k2 <= bias ? 1 : (k2 >= bias + 26 ? 26 : k2 - bias))) {
                    output.append((char)PunyCode.digit2codepoint(t2 + (q2 - t2) % (36 - t2)));
                    q2 = (q2 - t2) / (36 - t2);
                    k2 += 36;
                }
                output.append((char)PunyCode.digit2codepoint(q2));
                bias = PunyCode.adapt(delta, h2 + 1, h2 == b2);
                delta = 0;
                ++h2;
            }
            ++delta;
            ++n2;
        }
        if (withPrefix) {
            output.insert(0, PUNY_CODE_PREFIX);
        }
        return output.toString();
    }

    public static String decode(String input) throws UtilException {
        input = StrUtil.removePrefixIgnoreCase(input, PUNY_CODE_PREFIX);
        int n2 = 128;
        int i2 = 0;
        int bias = 72;
        StringBuilder output = new StringBuilder();
        int d2 = input.lastIndexOf(45);
        if (d2 > 0) {
            for (int j2 = 0; j2 < d2; ++j2) {
                char c2 = input.charAt(j2);
                if (!PunyCode.isBasic(c2)) continue;
                output.append(c2);
            }
            ++d2;
        } else {
            d2 = 0;
        }
        int length = input.length();
        while (d2 < length) {
            int oldi = i2;
            int w2 = 1;
            int k2 = 36;
            while (true) {
                char c3;
                int digit;
                if (d2 == length) {
                    throw new UtilException("BAD_INPUT");
                }
                if ((digit = PunyCode.codepoint2digit(c3 = input.charAt(d2++))) > (Integer.MAX_VALUE - i2) / w2) {
                    throw new UtilException("OVERFLOW");
                }
                i2 += digit * w2;
                int t2 = k2 <= bias ? 1 : (k2 >= bias + 26 ? 26 : k2 - bias);
                if (digit < t2) break;
                w2 *= 36 - t2;
                k2 += 36;
            }
            bias = PunyCode.adapt(i2 - oldi, output.length() + 1, oldi == 0);
            if (i2 / (output.length() + 1) > Integer.MAX_VALUE - n2) {
                throw new UtilException("OVERFLOW");
            }
            n2 += i2 / (output.length() + 1);
            output.insert(i2 %= output.length() + 1, (char)n2);
            ++i2;
        }
        return output.toString();
    }

    private static int adapt(int delta, int numpoints, boolean first) {
        delta = first ? (delta /= 700) : (delta /= 2);
        delta += delta / numpoints;
        int k2 = 0;
        while (delta > 455) {
            delta /= 35;
            k2 += 36;
        }
        return k2 + 36 * delta / (delta + 38);
    }

    private static boolean isBasic(char c2) {
        return c2 < '\u0080';
    }

    private static int digit2codepoint(int d2) throws UtilException {
        Assert.checkBetween(d2, 0, 35);
        if (d2 < 26) {
            return d2 + 97;
        }
        if (d2 < 36) {
            return d2 - 26 + 48;
        }
        throw new UtilException("BAD_INPUT");
    }

    private static int codepoint2digit(int c2) throws UtilException {
        if (c2 - 48 < 10) {
            return c2 - 48 + 26;
        }
        if (c2 - 97 < 26) {
            return c2 - 97;
        }
        throw new UtilException("BAD_INPUT");
    }
}

