/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

public class Rot {
    private static final char aCHAR = 'a';
    private static final char zCHAR = 'z';
    private static final char ACHAR = 'A';
    private static final char ZCHAR = 'Z';
    private static final char CHAR0 = '0';
    private static final char CHAR9 = '9';

    public static String encode13(String message) {
        return Rot.encode13(message, true);
    }

    public static String encode13(String message, boolean isEnocdeNumber) {
        return Rot.encode(message, 13, isEnocdeNumber);
    }

    public static String encode(String message, int offset, boolean isEnocdeNumber) {
        int len = message.length();
        char[] chars = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            chars[i2] = Rot.encodeChar(message.charAt(i2), offset, isEnocdeNumber);
        }
        return new String(chars);
    }

    public static String decode13(String rot) {
        return Rot.decode13(rot, true);
    }

    public static String decode13(String rot, boolean isDecodeNumber) {
        return Rot.decode(rot, 13, isDecodeNumber);
    }

    public static String decode(String rot, int offset, boolean isDecodeNumber) {
        int len = rot.length();
        char[] chars = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            chars[i2] = Rot.decodeChar(rot.charAt(i2), offset, isDecodeNumber);
        }
        return new String(chars);
    }

    private static char encodeChar(char c2, int offset, boolean isDecodeNumber) {
        if (isDecodeNumber && c2 >= '0' && c2 <= '9') {
            c2 = (char)(c2 - 48);
            c2 = (char)((c2 + offset) % 10);
            c2 = (char)(c2 + 48);
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 - 65);
            c2 = (char)((c2 + offset) % 26);
            c2 = (char)(c2 + 65);
        } else if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 97);
            c2 = (char)((c2 + offset) % 26);
            c2 = (char)(c2 + 97);
        }
        return c2;
    }

    private static char decodeChar(char c2, int offset, boolean isDecodeNumber) {
        int temp = c2;
        if (isDecodeNumber && temp >= 48 && temp <= 57) {
            temp -= 48;
            temp -= offset;
            while (temp < 0) {
                temp += 10;
            }
            temp += 48;
        }
        if (temp >= 65 && temp <= 90) {
            temp -= 65;
            temp -= offset;
            while (temp < 0) {
                temp = 26 + temp;
            }
            temp += 65;
        } else if (temp >= 97 && temp <= 122) {
            temp -= 97;
            if ((temp -= offset) < 0) {
                temp = 26 + temp;
            }
            temp += 97;
        }
        return (char)temp;
    }
}

