/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.comparator.ComparatorException;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.Comparator;

public class PropertyComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 9157326766723846313L;
    private final String property;
    private final boolean isNullGreater;

    public PropertyComparator(String property) {
        this(property, true);
    }

    public PropertyComparator(String property, boolean isNullGreater) {
        this.property = property;
        this.isNullGreater = isNullGreater;
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable v2;
        Comparable v1;
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return this.isNullGreater ? 1 : -1;
        }
        if (null == o2) {
            return this.isNullGreater ? -1 : 1;
        }
        try {
            v1 = (Comparable)BeanUtil.getProperty(o1, this.property);
            v2 = (Comparable)BeanUtil.getProperty(o2, this.property);
        }
        catch (Exception e2) {
            throw new ComparatorException(e2);
        }
        return this.compare(o1, o2, v1, v2);
    }

    private int compare(T o1, T o2, Comparable fieldValue1, Comparable fieldValue2) {
        int result = ObjectUtil.compare(fieldValue1, fieldValue2, this.isNullGreater);
        if (0 == result) {
            result = CompareUtil.compare(o1, o2, this.isNullGreater);
        }
        return result;
    }
}

