/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.util.StrUtil;

public class NumberWordFormatter {
    private static final String[] NUMBER = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
    private static final String[] NUMBER_TEEN = new String[]{"TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
    private static final String[] NUMBER_TEN = new String[]{"TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
    private static final String[] NUMBER_MORE = new String[]{"", "THOUSAND", "MILLION", "BILLION"};

    public static String format(Object x2) {
        if (x2 != null) {
            return NumberWordFormatter.format(x2.toString());
        }
        return "";
    }

    private static String format(String x2) {
        String lstr;
        int z2 = x2.indexOf(".");
        String rstr = "";
        if (z2 > -1) {
            lstr = x2.substring(0, z2);
            rstr = x2.substring(z2 + 1);
        } else {
            lstr = x2;
        }
        String lstrrev = StrUtil.reverse(lstr);
        String[] a2 = new String[5];
        switch (lstrrev.length() % 3) {
            case 1: {
                lstrrev = lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = lstrrev + "0";
            }
        }
        StringBuilder lm = new StringBuilder();
        for (int i2 = 0; i2 < lstrrev.length() / 3; ++i2) {
            a2[i2] = StrUtil.reverse(lstrrev.substring(3 * i2, 3 * i2 + 3));
            if (!"000".equals(a2[i2])) {
                if (i2 != 0) {
                    lm.insert(0, NumberWordFormatter.transThree(a2[i2]) + " " + NumberWordFormatter.parseMore(i2) + " ");
                    continue;
                }
                lm = new StringBuilder(NumberWordFormatter.transThree(a2[i2]));
                continue;
            }
            lm.append(NumberWordFormatter.transThree(a2[i2]));
        }
        String xs = "";
        if (z2 > -1) {
            xs = "AND CENTS " + NumberWordFormatter.transTwo(rstr) + " ";
        }
        return lm.toString().trim() + " " + xs + "ONLY";
    }

    private static String parseFirst(String s2) {
        return NUMBER[Integer.parseInt(s2.substring(s2.length() - 1))];
    }

    private static String parseTeen(String s2) {
        return NUMBER_TEEN[Integer.parseInt(s2) - 10];
    }

    private static String parseTen(String s2) {
        return NUMBER_TEN[Integer.parseInt(s2.substring(0, 1)) - 1];
    }

    private static String parseMore(int i2) {
        return NUMBER_MORE[i2];
    }

    private static String transTwo(String s2) {
        if (s2.length() > 2) {
            s2 = s2.substring(0, 2);
        } else if (s2.length() < 2) {
            s2 = "0" + s2;
        }
        String value = s2.startsWith("0") ? NumberWordFormatter.parseFirst(s2) : (s2.startsWith("1") ? NumberWordFormatter.parseTeen(s2) : (s2.endsWith("0") ? NumberWordFormatter.parseTen(s2) : NumberWordFormatter.parseTen(s2) + " " + NumberWordFormatter.parseFirst(s2)));
        return value;
    }

    private static String transThree(String s2) {
        String value = s2.startsWith("0") ? NumberWordFormatter.transTwo(s2.substring(1)) : ("00".equals(s2.substring(1)) ? NumberWordFormatter.parseFirst(s2.substring(0, 1)) + " HUNDRED" : NumberWordFormatter.parseFirst(s2.substring(0, 1)) + " HUNDRED AND " + NumberWordFormatter.transTwo(s2.substring(1)));
        return value;
    }
}

