/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.io.FastByteBuffer;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class FastByteArrayOutputStream
extends OutputStream {
    private final FastByteBuffer buffer;

    public FastByteArrayOutputStream() {
        this(1024);
    }

    public FastByteArrayOutputStream(int size) {
        this.buffer = new FastByteBuffer(size);
    }

    @Override
    public void write(byte[] b2, int off, int len) {
        this.buffer.append(b2, off, len);
    }

    @Override
    public void write(int b2) {
        this.buffer.append((byte)b2);
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.buffer.reset();
    }

    public void writeTo(OutputStream out) throws IORuntimeException {
        int index = this.buffer.index();
        try {
            for (int i2 = 0; i2 < index; ++i2) {
                byte[] buf = this.buffer.array(i2);
                out.write(buf);
            }
            out.write(this.buffer.array(index), 0, this.buffer.offset());
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public String toString() {
        return this.toString(CharsetUtil.defaultCharset());
    }

    public String toString(String charsetName) {
        return this.toString(CharsetUtil.charset(charsetName));
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), ObjectUtil.defaultIfNull(charset, CharsetUtil.defaultCharset()));
    }
}

