/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectId {
    private static final AtomicInteger NEXT_INC = new AtomicInteger(RandomUtil.randomInt());
    private static final int MACHINE = ObjectId.getMachinePiece() | ObjectId.getProcessPiece();

    public static boolean isValid(String s2) {
        if (s2 == null) {
            return false;
        }
        int len = (s2 = StrUtil.removeAll((CharSequence)s2, "-")).length();
        if (len != 24) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') continue;
            return false;
        }
        return true;
    }

    public static byte[] nextBytes() {
        ByteBuffer bb = ByteBuffer.wrap(new byte[12]);
        bb.putInt((int)DateUtil.currentSeconds());
        bb.putInt(MACHINE);
        bb.putInt(NEXT_INC.getAndIncrement());
        return bb.array();
    }

    public static String next() {
        return ObjectId.next(false);
    }

    public static String next(boolean withHyphen) {
        byte[] array = ObjectId.nextBytes();
        StringBuilder buf = new StringBuilder(withHyphen ? 26 : 24);
        for (int i2 = 0; i2 < array.length; ++i2) {
            int t2;
            if (withHyphen && i2 % 4 == 0 && i2 != 0) {
                buf.append("-");
            }
            if ((t2 = array[i2] & 0xFF) < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(t2));
        }
        return buf.toString();
    }

    private static int getMachinePiece() {
        int machinePiece;
        try {
            StringBuilder netSb = new StringBuilder();
            Enumeration<NetworkInterface> e2 = NetworkInterface.getNetworkInterfaces();
            while (e2.hasMoreElements()) {
                NetworkInterface ni = e2.nextElement();
                netSb.append(ni.toString());
            }
            machinePiece = netSb.toString().hashCode() << 16;
        }
        catch (Throwable e3) {
            machinePiece = RandomUtil.randomInt() << 16;
        }
        return machinePiece;
    }

    private static int getProcessPiece() {
        int processId;
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            int atIndex = processName.indexOf(64);
            processId = atIndex > 0 ? Integer.parseInt(processName.substring(0, atIndex)) : processName.hashCode();
        }
        catch (Throwable t2) {
            processId = RandomUtil.randomInt();
        }
        ClassLoader loader = ClassLoaderUtil.getClassLoader();
        int loaderId = loader != null ? System.identityHashCode(loader) : 0;
        String processSb = Integer.toHexString(processId) + Integer.toHexString(loaderId);
        int processPiece = processSb.hashCode() & 0xFFFF;
        return processPiece;
    }
}

