/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.func.Func0;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleCache<K, V>
implements Iterable<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> cache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Map<K, Lock> keyLockMap = new ConcurrentHashMap<K, Lock>();

    public SimpleCache() {
        this(new WeakHashMap());
    }

    public SimpleCache(Map<K, V> initMap) {
        this.cache = initMap;
    }

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v2 = this.cache.get(key);
            return v2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Func0<V> supplier) {
        V v2;
        block6: {
            v2 = this.get(key);
            if (null == v2 && null != supplier) {
                Lock keyLock = this.keyLockMap.computeIfAbsent(key, k2 -> new ReentrantLock());
                keyLock.lock();
                try {
                    v2 = this.cache.get(key);
                    if (null != v2) break block6;
                    try {
                        v2 = supplier.call();
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                    this.put(key, v2);
                }
                finally {
                    keyLock.unlock();
                    this.keyLockMap.remove(key);
                }
            }
        }
        return v2;
    }

    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.cache.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v2 = this.cache.remove(key);
            return v2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.cache.entrySet().iterator();
    }
}

