/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Stack;

public class Calculator {
    private final Stack<String> postfixStack = new Stack();
    private final Stack<Character> opStack = new Stack();
    private final int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static double conversion(String expression) {
        Calculator cal = new Calculator();
        expression = Calculator.transform(expression);
        return cal.calculate(expression);
    }

    private static String transform(String expression) {
        expression = StrUtil.cleanBlank(expression);
        expression = StrUtil.removeSuffix(expression, "=");
        char[] arr = expression.toCharArray();
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (arr[i2] != '-') continue;
            if (i2 == 0) {
                arr[i2] = 126;
                continue;
            }
            char c2 = arr[i2 - 1];
            if (c2 != '+' && c2 != '-' && c2 != '*' && c2 != '/' && c2 != '(' && c2 != 'E' && c2 != 'e') continue;
            arr[i2] = 126;
        }
        if (arr[0] == '~' || arr.length > 1 && arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    public double calculate(String expression) {
        Stack<String> resultStack = new Stack<String>();
        this.prepare(expression);
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentValue = this.postfixStack.pop();
            if (!this.isOperator(currentValue.charAt(0))) {
                currentValue = currentValue.replace("~", "-");
                resultStack.push(currentValue);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            BigDecimal tempResult = this.calculate(firstValue, secondValue, currentValue.charAt(0));
            resultStack.push(tempResult.toString());
        }
        return Double.parseDouble((String)resultStack.pop());
    }

    private void prepare(String expression) {
        this.opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        for (int i2 = 0; i2 < arr.length; ++i2) {
            char currentOp = arr[i2];
            if (this.isOperator(currentOp)) {
                if (count > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count));
                }
                char peekOp = this.opStack.peek().charValue();
                if (currentOp == ')') {
                    while (this.opStack.peek().charValue() != '(') {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                    }
                    this.opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        peekOp = this.opStack.peek().charValue();
                    }
                    this.opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i2 + 1;
                continue;
            }
            ++count;
        }
        if (count > 1 || count == 1 && !this.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count));
        }
        while (this.opStack.peek().charValue() != ',') {
            this.postfixStack.push(String.valueOf(this.opStack.pop()));
        }
    }

    private boolean isOperator(char c2) {
        return c2 == '+' || c2 == '-' || c2 == '*' || c2 == '/' || c2 == '(' || c2 == ')';
    }

    public boolean compare(char cur, char peek) {
        boolean result = false;
        if (this.operatPriority[peek - 40] >= this.operatPriority[cur - 40]) {
            result = true;
        }
        return result;
    }

    private BigDecimal calculate(String firstValue, String secondValue, char currentOp) {
        BigDecimal result;
        switch (currentOp) {
            case '+': {
                result = NumberUtil.add(firstValue, secondValue);
                break;
            }
            case '-': {
                result = NumberUtil.sub(firstValue, secondValue);
                break;
            }
            case '*': {
                result = NumberUtil.mul(firstValue, secondValue);
                break;
            }
            case '/': {
                result = NumberUtil.div(firstValue, secondValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + currentOp);
            }
        }
        return result;
    }
}

