/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.net.MaskBit;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Ipv4Util {
    public static final String IP_SPLIT_MARK = "-";
    public static final String IP_MASK_SPLIT_MARK = "/";
    public static final int IP_MASK_MAX = 32;

    public static String formatIpBlock(String ip, String mask) {
        return ip + IP_MASK_SPLIT_MARK + Ipv4Util.getMaskBitByMask(mask);
    }

    public static List<String> list(String ipRange, boolean isAll) {
        if (ipRange.contains(IP_SPLIT_MARK)) {
            String[] range = StrUtil.split((CharSequence)ipRange, IP_SPLIT_MARK);
            return Ipv4Util.list(range[0], range[1]);
        }
        if (ipRange.contains(IP_MASK_SPLIT_MARK)) {
            String[] param = StrUtil.split((CharSequence)ipRange, IP_MASK_SPLIT_MARK);
            return Ipv4Util.list(param[0], Integer.parseInt(param[1]), isAll);
        }
        return ListUtil.toList(ipRange);
    }

    public static List<String> list(String ip, int maskBit, boolean isAll) {
        if (maskBit == 32) {
            ArrayList<String> list = new ArrayList<String>();
            if (isAll) {
                list.add(ip);
            }
            return list;
        }
        String startIp = Ipv4Util.getBeginIpStr(ip, maskBit);
        String endIp = Ipv4Util.getEndIpStr(ip, maskBit);
        if (isAll) {
            return Ipv4Util.list(startIp, endIp);
        }
        int lastDotIndex = startIp.lastIndexOf(46) + 1;
        startIp = StrUtil.subPre(startIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StrUtil.subSuf(startIp, lastDotIndex))) + 1);
        lastDotIndex = endIp.lastIndexOf(46) + 1;
        endIp = StrUtil.subPre(endIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StrUtil.subSuf(endIp, lastDotIndex))) - 1);
        return Ipv4Util.list(startIp, endIp);
    }

    public static List<String> list(String ipFrom, String ipTo) {
        int[] ipf = Convert.convert(int[].class, (Object)StrUtil.splitToArray(ipFrom, '.'));
        int[] ipt = Convert.convert(int[].class, (Object)StrUtil.splitToArray(ipTo, '.'));
        ArrayList<String> ips = new ArrayList<String>();
        for (int a2 = ipf[0]; a2 <= ipt[0]; ++a2) {
            for (int b2 = a2 == ipf[0] ? ipf[1] : 0; b2 <= (a2 == ipt[0] ? ipt[1] : 255); ++b2) {
                for (int c2 = b2 == ipf[1] ? ipf[2] : 0; c2 <= (b2 == ipt[1] ? ipt[2] : 255); ++c2) {
                    for (int d2 = c2 == ipf[2] ? ipf[3] : 0; d2 <= (c2 == ipt[2] ? ipt[3] : 255); ++d2) {
                        ips.add(a2 + "." + b2 + "." + c2 + "." + d2);
                    }
                }
            }
        }
        return ips;
    }

    public static String longToIpv4(long longIP) {
        StringBuilder sb = StrUtil.builder();
        sb.append(longIP >> 24 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 16 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 8 & 0xFFL);
        sb.append('.');
        sb.append(longIP & 0xFFL);
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        Validator.validateIpv4(strIP, "Invalid IPv4 address!");
        long[] ip = Convert.convert(long[].class, StrUtil.split((CharSequence)strIP, '.'));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String getBeginIpStr(String ip, int maskBit) {
        return Ipv4Util.longToIpv4(Ipv4Util.getBeginIpLong(ip, maskBit));
    }

    private static Long getBeginIpLong(String ip, int maskBit) {
        return Ipv4Util.ipv4ToLong(ip) & Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit(maskBit));
    }

    public static String getEndIpStr(String ip, int maskBit) {
        return Ipv4Util.longToIpv4(Ipv4Util.getEndIpLong(ip, maskBit));
    }

    public static int getMaskBitByMask(String mask) {
        int inetmask = 0;
        for (String part : StrUtil.split((CharSequence)mask, '.')) {
            StringBuffer sbf = Ipv4Util.toBin(Integer.parseInt(part));
            String str = sbf.reverse().toString();
            int count = 0;
            for (int i2 = 0; i2 < str.length() && (i2 = str.indexOf(49, i2)) != -1; ++i2) {
                ++count;
            }
            inetmask += count;
        }
        return inetmask;
    }

    public static int countByMaskBit(int maskBit, boolean isAll) {
        if (!(isAll || maskBit > 0 && maskBit < 32)) {
            return 0;
        }
        int count = (int)Math.pow(2.0, 32 - maskBit);
        return isAll ? count : count - 2;
    }

    public static String getMaskByMaskBit(int maskBit) {
        return MaskBit.get(maskBit);
    }

    public static String getMaskByIpRange(String fromIp, String toIp) {
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long fromIpLong = Ipv4Util.ipv4ToLong(fromIp);
        Assert.isTrue(fromIpLong < toIpLong, "to IP must be greater than from IP!", new Object[0]);
        String[] fromIpSplit = StrUtil.splitToArray(fromIp, '.');
        String[] toIpSplit = StrUtil.splitToArray(toIp, '.');
        StringBuilder mask = new StringBuilder();
        for (int i2 = 0; i2 < toIpSplit.length; ++i2) {
            mask.append(255 - Integer.parseInt(toIpSplit[i2]) + Integer.parseInt(fromIpSplit[i2])).append('.');
        }
        return mask.substring(0, mask.length() - 1);
    }

    public static int countByIpRange(String fromIp, String toIp) {
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long fromIpLong = Ipv4Util.ipv4ToLong(fromIp);
        if (fromIpLong > toIpLong) {
            throw new IllegalArgumentException("to IP must be greater than from IP!");
        }
        int count = 1;
        int[] fromIpSplit = StrUtil.split((CharSequence)fromIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        int[] toIpSplit = StrUtil.split((CharSequence)toIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        for (int i2 = fromIpSplit.length - 1; i2 >= 0; --i2) {
            count = (int)((double)count + (double)(toIpSplit[i2] - fromIpSplit[i2]) * Math.pow(256.0, fromIpSplit.length - i2 - 1));
        }
        return count;
    }

    private static Long getEndIpLong(String ip, int maskBit) {
        return Ipv4Util.getBeginIpLong(ip, maskBit) + (Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit(maskBit)) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static StringBuffer toBin(int x2) {
        StringBuffer result = new StringBuffer();
        result.append(x2 % 2);
        x2 /= 2;
        while (x2 > 0) {
            result.append(x2 % 2);
            x2 /= 2;
        }
        return result;
    }
}

