/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public class URLDecoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte ESCAPE_CHAR = 37;

    public static String decode(String str, Charset charset) {
        return StrUtil.str(URLDecoder.decode(StrUtil.bytes((CharSequence)str, charset)), charset);
    }

    public static byte[] decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(bytes.length);
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            byte b2 = bytes[i2];
            if (b2 == 43) {
                buffer.write(32);
                continue;
            }
            if (b2 == 37) {
                int l2;
                int u2;
                if (i2 + 1 < bytes.length && (u2 = CharUtil.digit16(bytes[i2 + 1])) >= 0 && i2 + 2 < bytes.length && (l2 = CharUtil.digit16(bytes[i2 + 2])) >= 0) {
                    buffer.write((char)((u2 << 4) + l2));
                    i2 += 2;
                    continue;
                }
                buffer.write(b2);
                continue;
            }
            buffer.write(b2);
        }
        return buffer.toByteArray();
    }
}

