/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.text.ASCIIStrCache;

public class CharUtil {
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final char DOT = '.';
    public static final char SLASH = '/';
    public static final char BACKSLASH = '\\';
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char DASHED = '-';
    public static final char UNDERLINE = '_';
    public static final char COMMA = ',';
    public static final char DELIM_START = '{';
    public static final char DELIM_END = '}';
    public static final char BRACKET_START = '[';
    public static final char BRACKET_END = ']';
    public static final char DOUBLE_QUOTES = '\"';
    public static final char SINGLE_QUOTE = '\'';
    public static final char AMP = '&';
    public static final char COLON = ':';
    public static final char AT = '@';

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isLetter(char ch) {
        return CharUtil.isLetterUpper(ch) || CharUtil.isLetterLower(ch);
    }

    public static boolean isLetterUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLetterLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isHexChar(char c2) {
        return CharUtil.isNumber(c2) || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
    }

    public static boolean isLetterOrNumber(char ch) {
        return CharUtil.isLetter(ch) || CharUtil.isNumber(ch);
    }

    public static String toString(char c2) {
        return ASCIIStrCache.toString(c2);
    }

    public static boolean isCharClass(Class<?> clazz) {
        return clazz == Character.class || clazz == Character.TYPE;
    }

    public static boolean isChar(Object value) {
        return value instanceof Character || value.getClass() == Character.TYPE;
    }

    public static boolean isBlankChar(char c2) {
        return CharUtil.isBlankChar((int)c2);
    }

    public static boolean isBlankChar(int c2) {
        return Character.isWhitespace(c2) || Character.isSpaceChar(c2) || c2 == 65279 || c2 == 8234;
    }

    public static boolean isEmoji(char c2) {
        return false == (c2 == '\u0000' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 >= ' ' && c2 <= '\ud7ff' || c2 >= '\ue000' && c2 <= '\ufffd' || c2 >= '\u100000' && c2 <= '\u10ffff');
    }

    public static boolean isFileSeparator(char c2) {
        return '/' == c2 || '\\' == c2;
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static int getType(int c2) {
        return Character.getType(c2);
    }

    public static int digit16(int b2) {
        return Character.digit(b2, 16);
    }
}

