/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

public class RadixUtil {
    public static final String RADIXS_34 = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    public static final String RADIXS_SHUFFLE_34 = "H3UM16TDFPSBZJ90CW28QYRE45AXKNGV7L";
    public static final String RADIXS_59 = "0123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ";
    public static final String RADIXS_SHUFFLE_59 = "vh9wGkfK8YmqbsoENP3764SeCX0dVzrgy1HRtpnTaLjJW2xQiZAcBMUFDu5";

    public static String encode(String radixs, int num) {
        long tmpNum = num >= 0 ? (long)num : 0x100000000L - (long)(~num + 1);
        return RadixUtil.encode(radixs, num, 32);
    }

    public static String encode(String radixs, long num) {
        if (num < 0L) {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u8d1f\u6570\uff01");
        }
        return RadixUtil.encode(radixs, num, 64);
    }

    private static String encode(String radixs, long num, int maxLength) {
        if (radixs.length() < 2) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u8fdb\u5236\u6700\u5c11\u4e24\u4e2a\u5b57\u7b26\u54e6\uff01");
        }
        int rl = radixs.length();
        long tmpNum = num;
        char[] aa2 = new char[maxLength];
        int i2 = aa2.length;
        do {
            aa2[--i2] = radixs.charAt((int)(tmpNum % (long)rl));
        } while ((tmpNum /= (long)rl) > 0L);
        return new String(aa2, i2, aa2.length - i2);
    }

    public int decodeToInt(String radixs, String encodeStr) {
        return (int)this.decode(radixs, encodeStr);
    }

    public long decode(String radixs, String encodeStr) {
        int rl = radixs.length();
        long res = 0L;
        for (char c2 : encodeStr.toCharArray()) {
            res = res * (long)rl + (long)radixs.indexOf(c2);
        }
        return res;
    }
}

