/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.matcher.AlwaysTrueValueMatcher;
import cn.hutool.cron.pattern.matcher.DayOfMonthValueMatcher;
import cn.hutool.cron.pattern.matcher.ValueMatcher;
import cn.hutool.cron.pattern.matcher.ValueMatcherBuilder;
import cn.hutool.cron.pattern.parser.DayOfMonthValueParser;
import cn.hutool.cron.pattern.parser.DayOfWeekValueParser;
import cn.hutool.cron.pattern.parser.HourValueParser;
import cn.hutool.cron.pattern.parser.MinuteValueParser;
import cn.hutool.cron.pattern.parser.MonthValueParser;
import cn.hutool.cron.pattern.parser.SecondValueParser;
import cn.hutool.cron.pattern.parser.ValueParser;
import cn.hutool.cron.pattern.parser.YearValueParser;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class CronPattern {
    private static final ValueParser SECOND_VALUE_PARSER = new SecondValueParser();
    private static final ValueParser MINUTE_VALUE_PARSER = new MinuteValueParser();
    private static final ValueParser HOUR_VALUE_PARSER = new HourValueParser();
    private static final ValueParser DAY_OF_MONTH_VALUE_PARSER = new DayOfMonthValueParser();
    private static final ValueParser MONTH_VALUE_PARSER = new MonthValueParser();
    private static final ValueParser DAY_OF_WEEK_VALUE_PARSER = new DayOfWeekValueParser();
    private static final ValueParser YEAR_VALUE_PARSER = new YearValueParser();
    private final String pattern;
    private final List<ValueMatcher> secondMatchers = new ArrayList<ValueMatcher>();
    private final List<ValueMatcher> minuteMatchers = new ArrayList<ValueMatcher>();
    private final List<ValueMatcher> hourMatchers = new ArrayList<ValueMatcher>();
    private final List<ValueMatcher> dayOfMonthMatchers = new ArrayList<ValueMatcher>();
    private final List<ValueMatcher> monthMatchers = new ArrayList<ValueMatcher>();
    private final List<ValueMatcher> dayOfWeekMatchers = new ArrayList<ValueMatcher>();
    private final List<ValueMatcher> yearMatchers = new ArrayList<ValueMatcher>();
    private int matcherSize;

    public CronPattern(String pattern) {
        this.pattern = pattern;
        this.parseGroupPattern(pattern);
    }

    public boolean match(long millis, boolean isMatchSecond) {
        return this.match(TimeZone.getDefault(), millis, isMatchSecond);
    }

    public boolean match(TimeZone timezone, long millis, boolean isMatchSecond) {
        GregorianCalendar calendar = new GregorianCalendar(timezone);
        calendar.setTimeInMillis(millis);
        return this.match(calendar, isMatchSecond);
    }

    public boolean match(GregorianCalendar calendar, boolean isMatchSecond) {
        int second = calendar.get(13);
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        int dayOfMonth = calendar.get(5);
        int month = calendar.get(2) + 1;
        int dayOfWeek = calendar.get(7) - 1;
        int year = calendar.get(1);
        for (int i2 = 0; i2 < this.matcherSize; ++i2) {
            boolean eval;
            boolean bl = eval = (false == isMatchSecond || this.secondMatchers.get(i2).match(second)) && this.minuteMatchers.get(i2).match(minute) && this.hourMatchers.get(i2).match(hour) && CronPattern.isMatchDayOfMonth(this.dayOfMonthMatchers.get(i2), dayOfMonth, month, calendar.isLeapYear(year)) && this.monthMatchers.get(i2).match(month) && this.dayOfWeekMatchers.get(i2).match(dayOfWeek) && CronPattern.isMatch(this.yearMatchers, i2, year);
            if (!eval) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.pattern;
    }

    private static boolean isMatchDayOfMonth(ValueMatcher matcher, int dayOfMonth, int month, boolean isLeapYear) {
        return matcher instanceof DayOfMonthValueMatcher ? ((DayOfMonthValueMatcher)matcher).match(dayOfMonth, month, isLeapYear) : matcher.match(dayOfMonth);
    }

    private static boolean isMatch(List<ValueMatcher> matchers, int index, int value) {
        return matchers.size() <= index || matchers.get(index).match(value);
    }

    private void parseGroupPattern(String groupPattern) {
        List<String> patternList = StrUtil.split((CharSequence)groupPattern, '|');
        for (String pattern : patternList) {
            this.parseSinglePattern(pattern);
        }
    }

    private void parseSinglePattern(String pattern) {
        String[] parts = pattern.split("\\s");
        int offset = 0;
        if (parts.length == 6 || parts.length == 7) {
            offset = 1;
        } else if (parts.length != 5) {
            throw new CronException("Pattern [{}] is invalid, it must be 5-7 parts!", pattern);
        }
        if (1 == offset) {
            try {
                this.secondMatchers.add(ValueMatcherBuilder.build(parts[0], SECOND_VALUE_PARSER));
            }
            catch (Exception e2) {
                throw new CronException(e2, "Invalid pattern [{}], parsing 'second' field error!", pattern);
            }
        } else {
            this.secondMatchers.add(ValueMatcherBuilder.build(String.valueOf(DateUtil.date().second()), SECOND_VALUE_PARSER));
        }
        try {
            this.minuteMatchers.add(ValueMatcherBuilder.build(parts[offset], MINUTE_VALUE_PARSER));
        }
        catch (Exception e3) {
            throw new CronException(e3, "Invalid pattern [{}], parsing 'minute' field error!", pattern);
        }
        try {
            this.hourMatchers.add(ValueMatcherBuilder.build(parts[1 + offset], HOUR_VALUE_PARSER));
        }
        catch (Exception e4) {
            throw new CronException(e4, "Invalid pattern [{}], parsing 'hour' field error!", pattern);
        }
        try {
            this.dayOfMonthMatchers.add(ValueMatcherBuilder.build(parts[2 + offset], DAY_OF_MONTH_VALUE_PARSER));
        }
        catch (Exception e5) {
            throw new CronException(e5, "Invalid pattern [{}], parsing 'day of month' field error!", pattern);
        }
        try {
            this.monthMatchers.add(ValueMatcherBuilder.build(parts[3 + offset], MONTH_VALUE_PARSER));
        }
        catch (Exception e6) {
            throw new CronException(e6, "Invalid pattern [{}], parsing 'month' field error!", pattern);
        }
        try {
            this.dayOfWeekMatchers.add(ValueMatcherBuilder.build(parts[4 + offset], DAY_OF_WEEK_VALUE_PARSER));
        }
        catch (Exception e7) {
            throw new CronException(e7, "Invalid pattern [{}], parsing 'day of week' field error!", pattern);
        }
        if (parts.length == 7) {
            try {
                this.yearMatchers.add(ValueMatcherBuilder.build(parts[6], YEAR_VALUE_PARSER));
            }
            catch (Exception e8) {
                throw new CronException(e8, "Invalid pattern [{}], parsing 'year' field error!", pattern);
            }
        } else {
            this.yearMatchers.add(new AlwaysTrueValueMatcher());
        }
        ++this.matcherSize;
    }
}

