/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.parser;

import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.parser.SimpleValueParser;

public class DayOfWeekValueParser
extends SimpleValueParser {
    private static final String[] ALIASES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};

    public DayOfWeekValueParser() {
        super(0, 7);
    }

    @Override
    public int parse(String value) throws CronException {
        try {
            return super.parse(value) % 7;
        }
        catch (Exception e2) {
            return this.parseAlias(value);
        }
    }

    private int parseAlias(String value) throws CronException {
        if ("L".equalsIgnoreCase(value)) {
            return ALIASES.length - 1;
        }
        for (int i2 = 0; i2 < ALIASES.length; ++i2) {
            if (!ALIASES[i2].equalsIgnoreCase(value)) continue;
            return i2;
        }
        throw new CronException("Invalid month alias: {}", value);
    }
}

