/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class ECKeyUtil {
    public static AsymmetricKeyParameter toParams(Key key) {
        if (key instanceof PrivateKey) {
            return ECKeyUtil.toPrivateParams((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return ECKeyUtil.toPublicParams((PublicKey)key);
        }
        return null;
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] q2) {
        return ECKeyUtil.toPublicParams(q2, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String q2) {
        return ECKeyUtil.toPublicParams(q2, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String x2, String y2) {
        return ECKeyUtil.toPublicParams(x2, y2, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] xBytes, byte[] yBytes) {
        return ECKeyUtil.toPublicParams(xBytes, yBytes, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toPublicParams(String x2, String y2, ECDomainParameters domainParameters) {
        return ECKeyUtil.toPublicParams(SecureUtil.decode(x2), SecureUtil.decode(y2), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        return ECKeyUtil.toPublicParams(BigIntegers.fromUnsignedByteArray((byte[])xBytes), BigIntegers.fromUnsignedByteArray((byte[])yBytes), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(BigInteger x2, BigInteger y2, ECDomainParameters domainParameters) {
        if (null == x2 || null == y2) {
            return null;
        }
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(curve.createPoint(x2, y2), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(String pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(curve.decodePoint(SecureUtil.decode(pointEncoded)), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(curve.decodePoint(pointEncoded), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(ECPoint point, ECDomainParameters domainParameters) {
        return new ECPublicKeyParameters(point, domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(PublicKey publicKey) {
        if (null == publicKey) {
            return null;
        }
        try {
            return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
        }
        catch (InvalidKeyException e2) {
            throw new CryptoException(e2);
        }
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(String d2) {
        return ECKeyUtil.toPrivateParams(d2, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(byte[] d2) {
        return ECKeyUtil.toPrivateParams(d2, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(BigInteger d2) {
        return ECKeyUtil.toPrivateParams(d2, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toPrivateParams(String d2, ECDomainParameters domainParameters) {
        return ECKeyUtil.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])SecureUtil.decode(d2)), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(byte[] d2, ECDomainParameters domainParameters) {
        return ECKeyUtil.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])d2), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(BigInteger d2, ECDomainParameters domainParameters) {
        if (null == d2) {
            return null;
        }
        return new ECPrivateKeyParameters(d2, domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(PrivateKey privateKey) {
        if (null == privateKey) {
            return null;
        }
        try {
            return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        }
        catch (InvalidKeyException e2) {
            throw new CryptoException(e2);
        }
    }
}

