/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.KeyUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemUtil {
    public static PrivateKey readPemPrivateKey(InputStream pemStream) {
        return (PrivateKey)PemUtil.readPemKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) {
        return (PublicKey)PemUtil.readPemKey(pemStream);
    }

    public static Key readPemKey(InputStream keyStream) {
        PemObject object = PemUtil.readPemObject(keyStream);
        String type = object.getType();
        if (StrUtil.isNotBlank(type)) {
            if (type.endsWith("PRIVATE KEY")) {
                return KeyUtil.generateRSAPrivateKey(object.getContent());
            }
            if (type.endsWith("PUBLIC KEY")) {
                return KeyUtil.generateRSAPublicKey(object.getContent());
            }
            if (type.endsWith("CERTIFICATE")) {
                return KeyUtil.readPublicKeyFromCert(IoUtil.toStream(object.getContent()));
            }
        }
        return null;
    }

    public static byte[] readPem(InputStream keyStream) {
        PemObject pemObject = PemUtil.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) {
        return PemUtil.readPemObject(IoUtil.getUtf8Reader(keyStream));
    }

    public static PemObject readPemObject(Reader reader) {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader(reader);
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable throwable) {
                IoUtil.close(pemReader);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)pemReader);
        return pemObject;
    }

    public static void writePemObject(String type, byte[] content, OutputStream keyStream) {
        PemUtil.writePemObject((PemObjectGenerator)new PemObject(type, content), keyStream);
    }

    public static void writePemObject(PemObjectGenerator pemObject, OutputStream keyStream) {
        PemWriter writer = null;
        try {
            writer = new PemWriter((Writer)IoUtil.getUtf8Writer(keyStream));
            writer.writeObject(pemObject);
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable throwable) {
                IoUtil.close(writer);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)writer);
    }
}

