/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.GlobalDbConfig;
import cn.hutool.db.Page;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectFactory;
import cn.hutool.db.handler.NumberHandler;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.SqlExecutor;
import cn.hutool.db.sql.SqlUtil;
import cn.hutool.db.sql.Wrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DialectRunner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Dialect dialect;
    protected boolean caseInsensitive = GlobalDbConfig.caseInsensitive;

    public DialectRunner(Dialect dialect) {
        this.dialect = dialect;
    }

    public DialectRunner(String driverClassName) {
        this(DialectFactory.newDialect(driverClassName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] insert(Connection conn, Entity ... records) throws SQLException {
        PreparedStatement ps;
        block4: {
            int[] nArray;
            this.checkConn(conn);
            if (ArrayUtil.isEmpty(records)) {
                return new int[]{0};
            }
            ps = null;
            try {
                if (1 != records.length) break block4;
                ps = this.dialect.psForInsert(conn, records[0]);
                nArray = new int[]{ps.executeUpdate()};
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
            return nArray;
        }
        ps = this.dialect.psForInsertBatch(conn, records);
        int[] nArray = ps.executeBatch();
        DbUtil.close(ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T insert(Connection conn, Entity record, RsHandler<T> generatedKeysHandler) throws SQLException {
        PreparedStatement ps;
        block4: {
            T t2;
            this.checkConn(conn);
            if (CollUtil.isEmpty(record)) {
                throw new SQLException("Empty entity provided!");
            }
            ps = null;
            try {
                ps = this.dialect.psForInsert(conn, record);
                ps.executeUpdate();
                if (null != generatedKeysHandler) break block4;
                t2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
            return t2;
        }
        T t3 = StatementUtil.getGeneratedKeys(ps, generatedKeysHandler);
        DbUtil.close(ps);
        return t3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int del(Connection conn, Entity where) throws SQLException {
        int n2;
        this.checkConn(conn);
        if (CollUtil.isEmpty(where)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForDelete(conn, Query.of(where));
            n2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection conn, Entity record, Entity where) throws SQLException {
        int n2;
        this.checkConn(conn);
        if (CollUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        if (CollUtil.isEmpty(where)) {
            throw new SQLException("Empty where provided!");
        }
        String tableName = record.getTableName();
        if (StrUtil.isBlank(tableName)) {
            tableName = where.getTableName();
            record.setTableName(tableName);
        }
        Query query = new Query(SqlUtil.buildConditions(where), tableName);
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdate(conn, record, query);
            n2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n2;
    }

    public <T> T find(Connection conn, Query query, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        Assert.notNull(query, "[query] is null !", new Object[0]);
        return SqlExecutor.queryAndClosePs(this.dialect.psForFind(conn, query), rsh, new Object[0]);
    }

    public long count(Connection conn, Entity where) throws SQLException {
        this.checkConn(conn);
        return SqlExecutor.queryAndClosePs(this.dialect.psForCount(conn, Query.of(where)), new NumberHandler(), new Object[0]).longValue();
    }

    public <T> T page(Connection conn, Query query, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == query.getPage()) {
            return this.find(conn, query, rsh);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, query), rsh, new Object[0]);
    }

    public <T> T page(Connection conn, SqlBuilder sqlBuilder, Page page, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            return SqlExecutor.query(conn, sqlBuilder, rsh);
        }
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, sqlBuilder, page), rsh, new Object[0]);
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setWrapper(Character wrapperChar) {
        this.setWrapper(new Wrapper(wrapperChar));
    }

    public void setWrapper(Wrapper wrapper) {
        this.dialect.setWrapper(wrapper);
    }

    private void checkConn(Connection conn) {
        Assert.notNull(conn, "Connection object must be not null!", new Object[0]);
    }
}

