/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedSql {
    private static final char[] NAME_START_CHARS = new char[]{':', '@', '?'};
    private String sql;
    private final List<Object> params = new LinkedList<Object>();

    public NamedSql(String namedSql, Map<String, Object> paramMap) {
        this.parse(namedSql, paramMap);
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getParams() {
        return this.params.toArray(new Object[0]);
    }

    public List<Object> getParamList() {
        return this.params;
    }

    private void parse(String namedSql, Map<String, Object> paramMap) {
        if (MapUtil.isEmpty(paramMap)) {
            this.sql = namedSql;
            return;
        }
        int len = namedSql.length();
        StrBuilder name = StrUtil.strBuilder();
        StrBuilder sqlBuilder = StrUtil.strBuilder();
        Character nameStartChar = null;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = namedSql.charAt(i2);
            if (ArrayUtil.contains(NAME_START_CHARS, c2)) {
                this.replaceVar(nameStartChar, name, sqlBuilder, paramMap);
                nameStartChar = Character.valueOf(c2);
                continue;
            }
            if (null != nameStartChar) {
                if (NamedSql.isGenerateChar(c2)) {
                    name.append(c2);
                    continue;
                }
                this.replaceVar(nameStartChar, name, sqlBuilder, paramMap);
                nameStartChar = null;
                sqlBuilder.append(c2);
                continue;
            }
            sqlBuilder.append(c2);
        }
        if (!name.isEmpty()) {
            this.replaceVar(nameStartChar, name, sqlBuilder, paramMap);
        }
        this.sql = sqlBuilder.toString();
    }

    private void replaceVar(Character nameStartChar, StrBuilder name, StrBuilder sqlBuilder, Map<String, Object> paramMap) {
        if (name.isEmpty()) {
            if (null != nameStartChar) {
                sqlBuilder.append(nameStartChar);
            }
            return;
        }
        String nameStr = name.toString();
        if (paramMap.containsKey(nameStr)) {
            Object paramValue = paramMap.get(nameStr);
            sqlBuilder.append('?');
            this.params.add(paramValue);
        } else {
            sqlBuilder.append(nameStartChar).append(name);
        }
        name.clear();
    }

    private static boolean isGenerateChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 >= '0' && c2 <= '9';
    }
}

