/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.collection.ArrayIter;
import cn.hutool.db.DbUtil;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.NamedSql;
import cn.hutool.db.sql.SqlBuilder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class SqlExecutor {
    public static int execute(Connection conn, String sql, Map<String, Object> paramMap) throws SQLException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.execute(conn, namedSql.getSql(), namedSql.getParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(Connection conn, String sql, Object ... params) throws SQLException {
        int n2;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(conn, sql, params);
            n2 = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean call(Connection conn, String sql, Object ... params) throws SQLException {
        boolean bl;
        CallableStatement call = null;
        try {
            call = StatementUtil.prepareCall(conn, sql, params);
            bl = call.execute();
        }
        catch (Throwable throwable) {
            DbUtil.close(call);
            throw throwable;
        }
        DbUtil.close(call);
        return bl;
    }

    public static ResultSet callQuery(Connection conn, String sql, Object ... params) throws SQLException {
        return StatementUtil.prepareCall(conn, sql, params).executeQuery();
    }

    public static Long executeForGeneratedKey(Connection conn, String sql, Map<String, Object> paramMap) throws SQLException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.executeForGeneratedKey(conn, namedSql.getSql(), namedSql.getParams());
    }

    /*
     * Exception decompiling
     */
    public static Long executeForGeneratedKey(Connection conn, String sql, Object ... params) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int[] executeBatch(Connection conn, String sql, Object[] ... paramsBatch) throws SQLException {
        return SqlExecutor.executeBatch(conn, sql, new ArrayIter<Object[]>(paramsBatch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        int[] nArray;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatementForBatch(conn, sql, paramsBatch);
            nArray = ps.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return nArray;
    }

    public static int[] executeBatch(Connection conn, String ... sqls) throws SQLException {
        return SqlExecutor.executeBatch(conn, new ArrayIter<String>(sqls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(Connection conn, Iterable<String> sqls) throws SQLException {
        Object object;
        Statement statement = null;
        try {
            statement = conn.createStatement();
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            object = statement.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.close(statement);
            throw throwable;
        }
        DbUtil.close(statement);
        return object;
    }

    public static <T> T query(Connection conn, String sql, RsHandler<T> rsh, Map<String, Object> paramMap) throws SQLException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.query(conn, namedSql.getSql(), rsh, namedSql.getParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T query(Connection conn, String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        T t2;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(conn, sql, params);
            t2 = SqlExecutor.executeQuery(ps, rsh);
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return t2;
    }

    public static <T> T query(Connection conn, SqlBuilder sqlBuilder, RsHandler<T> rsh) throws SQLException {
        return SqlExecutor.query(conn, sqlBuilder.build(), rsh, sqlBuilder.getParamValueArray());
    }

    public static int executeUpdate(PreparedStatement ps, Object ... params) throws SQLException {
        StatementUtil.fillParams(ps, params);
        return ps.executeUpdate();
    }

    public static boolean execute(PreparedStatement ps, Object ... params) throws SQLException {
        StatementUtil.fillParams(ps, params);
        return ps.execute();
    }

    public static <T> T query(PreparedStatement ps, RsHandler<T> rsh, Object ... params) throws SQLException {
        StatementUtil.fillParams(ps, params);
        return SqlExecutor.executeQuery(ps, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T queryAndClosePs(PreparedStatement ps, RsHandler<T> rsh, Object ... params) throws SQLException {
        T t2;
        try {
            t2 = SqlExecutor.query(ps, rsh, params);
        }
        catch (Throwable throwable) {
            DbUtil.close(ps);
            throw throwable;
        }
        DbUtil.close(ps);
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T executeQuery(PreparedStatement ps, RsHandler<T> rsh) throws SQLException {
        T t2;
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            t2 = rsh.handle(rs);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            throw throwable;
        }
        DbUtil.close(rs);
        return t2;
    }
}

