/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.compress.archiver;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.compress.archiver.Archiver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;

public class SevenZArchiver
implements Archiver {
    private final SevenZOutputFile sevenZOutputFile;
    private SeekableByteChannel channel;
    private OutputStream out;

    public SevenZArchiver(File file) {
        try {
            this.sevenZOutputFile = new SevenZOutputFile(file);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public SevenZArchiver(OutputStream out) {
        this.out = out;
        this.channel = new SeekableInMemoryByteChannel();
        try {
            this.sevenZOutputFile = new SevenZOutputFile(this.channel);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public SevenZArchiver(SeekableByteChannel channel) {
        try {
            this.sevenZOutputFile = new SevenZOutputFile(channel);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public SevenZOutputFile getSevenZOutputFile() {
        return this.sevenZOutputFile;
    }

    @Override
    public SevenZArchiver add(File file, String path, Filter<File> filter) {
        try {
            this.addInternal(file, path, filter);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return this;
    }

    @Override
    public SevenZArchiver finish() {
        try {
            this.sevenZOutputFile.finish();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != this.out && this.channel instanceof SeekableInMemoryByteChannel) {
            try {
                this.out.write(((SeekableInMemoryByteChannel)this.channel).array());
            }
            catch (IOException e2) {
                throw new IORuntimeException(e2);
            }
        }
        IoUtil.close((Closeable)this.sevenZOutputFile);
    }

    private void addInternal(File file, String path, Filter<File> filter) throws IOException {
        if (null != filter && !filter.accept(file)) {
            return;
        }
        SevenZOutputFile out = this.sevenZOutputFile;
        String entryName = StrUtil.addSuffixIfNot(StrUtil.nullToEmpty(path), "/") + file.getName();
        out.putArchiveEntry((ArchiveEntry)out.createArchiveEntry(file, entryName));
        if (file.isDirectory()) {
            File[] files;
            for (File childFile : files = file.listFiles()) {
                this.addInternal(childFile, entryName, filter);
            }
        } else {
            if (file.isFile()) {
                out.write(FileUtil.readBytes(file));
            }
            out.closeArchiveEntry();
        }
    }
}

