/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.webservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.webservice.SoapProtocol;
import cn.hutool.http.webservice.SoapRuntimeException;
import cn.hutool.http.webservice.SoapUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

public class SoapClient
extends HttpBase<SoapClient> {
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml;charset=";
    private String url;
    private int connectionTimeout = HttpGlobalConfig.getTimeout();
    private int readTimeout = HttpGlobalConfig.getTimeout();
    private MessageFactory factory;
    private SOAPMessage message;
    private SOAPBodyElement methodEle;
    private final String namespaceURI;

    public static SoapClient create(String url) {
        return new SoapClient(url);
    }

    public static SoapClient create(String url, SoapProtocol protocol) {
        return new SoapClient(url, protocol);
    }

    public static SoapClient create(String url, SoapProtocol protocol, String namespaceURI) {
        return new SoapClient(url, protocol, namespaceURI);
    }

    public SoapClient(String url) {
        this(url, SoapProtocol.SOAP_1_1);
    }

    public SoapClient(String url, SoapProtocol protocol) {
        this(url, protocol, null);
    }

    public SoapClient(String url, SoapProtocol protocol, String namespaceURI) {
        this.url = url;
        this.namespaceURI = namespaceURI;
        this.init(protocol);
    }

    public SoapClient init(SoapProtocol protocol) {
        try {
            this.factory = MessageFactory.newInstance((String)protocol.getValue());
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e2) {
            throw new SoapRuntimeException(e2);
        }
        return this;
    }

    public SoapClient reset() {
        try {
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e2) {
            throw new SoapRuntimeException(e2);
        }
        this.methodEle = null;
        return this;
    }

    public SoapClient setCharset(Charset charset) {
        return this.charset(charset);
    }

    @Override
    public SoapClient charset(Charset charset) {
        super.charset(charset);
        try {
            this.message.setProperty("javax.xml.soap.character-set-encoding", (Object)this.charset());
            this.message.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return this;
    }

    public SoapClient setUrl(String url) {
        this.url = url;
        return this;
    }

    @Deprecated
    public SoapClient setHeader(QName name) {
        return this.setSOAPHeader(name, null, null, null, null);
    }

    @Deprecated
    public SoapClient setSOAPHeader(QName name) {
        this.addSOAPHeader(name);
        return this;
    }

    @Deprecated
    public SoapClient setHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        return this.setSOAPHeader(name, actorURI, roleUri, mustUnderstand, relay);
    }

    @Deprecated
    public SoapClient setSOAPHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        this.addSOAPHeader(name, actorURI, roleUri, mustUnderstand, relay);
        return this;
    }

    public SOAPHeaderElement addSOAPHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        SOAPHeaderElement ele = this.addSOAPHeader(name);
        try {
            if (StrUtil.isNotBlank(roleUri)) {
                ele.setRole(roleUri);
            }
            if (null != relay) {
                ele.setRelay(relay.booleanValue());
            }
        }
        catch (SOAPException e2) {
            throw new SoapRuntimeException(e2);
        }
        if (StrUtil.isNotBlank(actorURI)) {
            ele.setActor(actorURI);
        }
        if (null != mustUnderstand) {
            ele.setMustUnderstand(mustUnderstand.booleanValue());
        }
        return ele;
    }

    public SOAPHeaderElement addSOAPHeader(String localName) {
        return this.addSOAPHeader(new QName(localName));
    }

    public SOAPHeaderElement addSOAPHeader(String localName, String value) {
        SOAPHeaderElement soapHeaderElement = this.addSOAPHeader(localName);
        soapHeaderElement.setTextContent(value);
        return soapHeaderElement;
    }

    public SOAPHeaderElement addSOAPHeader(QName name) {
        SOAPHeaderElement ele;
        try {
            ele = this.message.getSOAPHeader().addHeaderElement(name);
        }
        catch (SOAPException e2) {
            throw new SoapRuntimeException(e2);
        }
        return ele;
    }

    public SoapClient setMethod(Name name, Map<String, Object> params, boolean useMethodPrefix) {
        return this.setMethod(new QName(name.getURI(), name.getLocalName(), name.getPrefix()), params, useMethodPrefix);
    }

    public SoapClient setMethod(QName name, Map<String, Object> params, boolean useMethodPrefix) {
        this.setMethod(name);
        String prefix = name.getPrefix();
        SOAPBodyElement methodEle = this.methodEle;
        for (Map.Entry<String, Object> entry : MapUtil.wrap(params)) {
            SoapClient.setParam((SOAPElement)methodEle, entry.getKey(), entry.getValue(), prefix);
        }
        return this;
    }

    public SoapClient setMethod(String methodName) {
        return this.setMethod(methodName, ObjectUtil.defaultIfNull(this.namespaceURI, ""));
    }

    public SoapClient setMethod(String methodName, String namespaceURI) {
        List<String> methodNameList = StrUtil.split((CharSequence)methodName, ':');
        QName qName = 2 == methodNameList.size() ? new QName(namespaceURI, methodNameList.get(1), methodNameList.get(0)) : new QName(namespaceURI, methodName);
        return this.setMethod(qName);
    }

    public SoapClient setMethod(QName name) {
        try {
            this.methodEle = this.message.getSOAPBody().addBodyElement(name);
        }
        catch (SOAPException e2) {
            throw new SoapRuntimeException(e2);
        }
        return this;
    }

    public SoapClient setParam(String name, Object value) {
        return this.setParam(name, value, true);
    }

    public SoapClient setParam(String name, Object value, boolean useMethodPrefix) {
        SoapClient.setParam((SOAPElement)this.methodEle, name, value, useMethodPrefix ? this.methodEle.getPrefix() : null);
        return this;
    }

    public SoapClient setParams(Map<String, Object> params) {
        return this.setParams(params, true);
    }

    public SoapClient setParams(Map<String, Object> params, boolean useMethodPrefix) {
        for (Map.Entry<String, Object> entry : MapUtil.wrap(params)) {
            this.setParam(entry.getKey(), entry.getValue(), useMethodPrefix);
        }
        return this;
    }

    public SOAPBodyElement getMethodEle() {
        return this.methodEle;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public String getMsgStr(boolean pretty) {
        return SoapUtil.toString(this.message, pretty, this.charset);
    }

    public SoapClient write(OutputStream out) {
        try {
            this.message.writeTo(out);
        }
        catch (IOException | SOAPException e2) {
            throw new SoapRuntimeException(e2);
        }
        return this;
    }

    public SoapClient timeout(int milliseconds) {
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout(milliseconds);
        return this;
    }

    public SoapClient setConnectionTimeout(int milliseconds) {
        this.connectionTimeout = milliseconds;
        return this;
    }

    public SoapClient setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
        return this;
    }

    public SOAPMessage sendForMessage() {
        HttpResponse res = this.sendForResponse();
        MimeHeaders headers = new MimeHeaders();
        for (Map.Entry<String, List<String>> entry : res.headers().entrySet()) {
            if (!StrUtil.isNotEmpty(entry.getKey())) continue;
            headers.setHeader(entry.getKey(), (String)CollUtil.get((Collection)entry.getValue(), 0));
        }
        try {
            SOAPMessage sOAPMessage = this.factory.createMessage(headers, res.bodyStream());
            return sOAPMessage;
        }
        catch (IOException | SOAPException e2) {
            throw new SoapRuntimeException(e2);
        }
        finally {
            IoUtil.close(res);
        }
    }

    public String send() {
        return this.send(false);
    }

    public String send(boolean pretty) {
        String body = this.sendForResponse().body();
        return pretty ? XmlUtil.format(body) : body;
    }

    private HttpResponse sendForResponse() {
        return ((HttpRequest)HttpRequest.post(this.url).setFollowRedirects(true).setConnectionTimeout(this.connectionTimeout).setReadTimeout(this.readTimeout).contentType(this.getXmlContentType()).header(this.headers())).body(this.getMsgStr(false)).executeAsync();
    }

    private String getXmlContentType() {
        return TEXT_XML_CONTENT_TYPE.concat(this.charset.toString());
    }

    private static SOAPElement setParam(SOAPElement ele, String name, Object value, String prefix) {
        SOAPElement childEle;
        try {
            childEle = StrUtil.isNotBlank(prefix) ? ele.addChildElement(name, prefix) : ele.addChildElement(name);
        }
        catch (SOAPException e2) {
            throw new SoapRuntimeException(e2);
        }
        if (null != value) {
            if (value instanceof SOAPElement) {
                try {
                    ele.addChildElement((SOAPElement)value);
                }
                catch (SOAPException e3) {
                    throw new SoapRuntimeException(e3);
                }
            } else if (value instanceof Map) {
                Iterator iterator = ((Map)value).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry entry = obj = iterator.next();
                    SoapClient.setParam(childEle, entry.getKey().toString(), entry.getValue(), prefix);
                }
            } else {
                childEle.setValue(value.toString());
            }
        }
        return childEle;
    }
}

