/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONObjectIter;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class JSONArray
implements JSON,
JSONGetter<Integer>,
List<Object>,
RandomAccess {
    private static final long serialVersionUID = 2664900568717612292L;
    public static final int DEFAULT_CAPACITY = 10;
    private final List<Object> rawList;
    private final JSONConfig config;

    public JSONArray() {
        this(10);
    }

    public JSONArray(int initialCapacity) {
        this(initialCapacity, JSONConfig.create());
    }

    public JSONArray(JSONConfig config) {
        this(10, config);
    }

    public JSONArray(int initialCapacity, JSONConfig config) {
        this.rawList = new ArrayList<Object>(initialCapacity);
        this.config = config;
    }

    public JSONArray(Iterable<Object> list) {
        this();
        for (Object o2 : list) {
            this.add(o2);
        }
    }

    public JSONArray(Collection<Object> list) {
        this(list.size());
        this.addAll(list);
    }

    public JSONArray(JSONTokener x2) throws JSONException {
        this();
        this.init(x2);
    }

    public JSONArray(CharSequence source) throws JSONException {
        this();
        this.init(source);
    }

    public JSONArray(Object object) throws JSONException {
        this(object, true);
    }

    public JSONArray(Object object, boolean ignoreNullValue) throws JSONException {
        this(object, JSONConfig.create().setIgnoreNullValue(ignoreNullValue));
    }

    public JSONArray(Object object, JSONConfig jsonConfig) throws JSONException {
        this(10, jsonConfig);
        this.init(object);
    }

    @Override
    public JSONConfig getConfig() {
        return this.config;
    }

    public JSONArray setDateFormat(String format) {
        this.config.setDateFormat(format);
        return this;
    }

    public String join(String separator) throws JSONException {
        int len = this.rawList.size();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb.append(separator);
            }
            sb.append(InternalJSONUtil.valueToString(this.rawList.get(i2)));
        }
        return sb.toString();
    }

    @Override
    public Object get(int index) {
        return this.rawList.get(index);
    }

    @Override
    public Object getObj(Integer index, Object defaultValue) {
        return index < 0 || index >= this.size() ? defaultValue : this.rawList.get(index);
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create(expression).get(this);
    }

    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        return JSONConverter.jsonConvert(resultType, this.getByPath(expression), true);
    }

    @Override
    public void putByPath(String expression, Object value) {
        BeanPath.create(expression).set(this, value);
    }

    public JSONArray put(Object value) {
        return this.set(value);
    }

    public JSONArray set(Object value) {
        this.add(value);
        return this;
    }

    public JSONArray put(int index, Object value) throws JSONException {
        this.add(index, value);
        return this;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject(this.config);
        for (int i2 = 0; i2 < names.size(); ++i2) {
            jo.set(names.getStr(i2), this.getObj(i2));
        }
        return jo;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawList == null ? 0 : this.rawList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        if (this.rawList == null) {
            return other.rawList == null;
        }
        return this.rawList.equals(other.rawList);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.rawList.iterator();
    }

    public Iterable<JSONObject> jsonIter() {
        return new JSONObjectIter(this.iterator());
    }

    @Override
    public int size() {
        return this.rawList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawList.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.rawList.contains(o2);
    }

    @Override
    public Object[] toArray() {
        return this.rawList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return (Object[])JSONConverter.toArray(this, a2.getClass().getComponentType());
    }

    @Override
    public boolean add(Object e2) {
        return this.rawList.add(JSONUtil.wrap(e2, this.config));
    }

    @Override
    public Object remove(int index) {
        return index >= 0 && index < this.size() ? this.rawList.remove(index) : null;
    }

    @Override
    public boolean remove(Object o2) {
        return this.rawList.remove(o2);
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this.rawList.containsAll(c2);
    }

    @Override
    public boolean addAll(Collection<?> c2) {
        if (CollUtil.isEmpty(c2)) {
            return false;
        }
        for (Object obj : c2) {
            this.add(obj);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<?> c2) {
        if (CollUtil.isEmpty(c2)) {
            return false;
        }
        ArrayList<Object> list = new ArrayList<Object>(c2.size());
        for (Object object : c2) {
            list.add(JSONUtil.wrap(object, this.config));
        }
        return this.rawList.addAll(index, list);
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        return this.rawList.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        return this.rawList.retainAll(c2);
    }

    @Override
    public void clear() {
        this.rawList.clear();
    }

    @Override
    public Object set(int index, Object element) {
        return this.rawList.set(index, JSONUtil.wrap(element, this.config));
    }

    @Override
    public void add(int index, Object element) {
        if (index < 0) {
            throw new JSONException("JSONArray[{}] not found.", index);
        }
        if (index < this.size()) {
            InternalJSONUtil.testValidity(element);
            this.rawList.add(index, JSONUtil.wrap(element, this.config));
        } else {
            while (index != this.size()) {
                this.add(JSONNull.NULL);
            }
            this.set(element);
        }
    }

    @Override
    public int indexOf(Object o2) {
        return this.rawList.indexOf(o2);
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.rawList.lastIndexOf(o2);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.rawList.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.rawList.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.rawList.subList(fromIndex, toIndex);
    }

    public Object toArray(Class<?> arrayClass) {
        return JSONConverter.toArray(this, arrayClass);
    }

    public <T> List<T> toList(Class<T> elementType) {
        return JSONConverter.toList(this, elementType);
    }

    public String toString() {
        return this.toJSONString(0);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            return this.doWrite(writer, indentFactor, indent);
        }
        catch (IOException e2) {
            throw new JSONException(e2);
        }
    }

    private Writer doWrite(Writer writer, int indentFactor, int indent) throws IOException {
        writer.write(91);
        int newindent = indent + indentFactor;
        boolean isIgnoreNullValue = this.config.isIgnoreNullValue();
        boolean isFirst = true;
        for (Object obj : this.rawList) {
            if (ObjectUtil.isNull(obj) && isIgnoreNullValue) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(44);
            }
            if (indentFactor > 0) {
                writer.write(10);
            }
            InternalJSONUtil.indent(writer, newindent);
            InternalJSONUtil.writeValue(writer, obj, indentFactor, newindent, this.config);
        }
        if (indentFactor > 0) {
            writer.write(10);
        }
        InternalJSONUtil.indent(writer, indent);
        writer.write(93);
        return writer;
    }

    private void init(Object source) throws JSONException {
        if (null == source) {
            return;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(source.getClass());
        if (null != serializer && JSONArray.class.equals((Object)TypeUtil.getTypeArgument(serializer.getClass()))) {
            serializer.serialize(this, source);
        } else if (source instanceof CharSequence) {
            this.init((CharSequence)source);
        } else if (source instanceof JSONTokener) {
            this.init((JSONTokener)source);
        } else {
            Iterator<Object> iter;
            if (ArrayUtil.isArray(source)) {
                iter = new ArrayIter(source);
            } else if (source instanceof Iterator) {
                iter = (Iterator)source;
            } else if (source instanceof Iterable) {
                iter = ((Iterable)source).iterator();
            } else {
                throw new JSONException("JSONArray initial value should be a string or collection or array.");
            }
            while (iter.hasNext()) {
                this.add(iter.next());
            }
        }
    }

    private void init(CharSequence source) {
        if (null != source) {
            this.init(new JSONTokener(StrUtil.trim(source), this.config));
        }
    }

    private void init(JSONTokener x2) {
        if (x2.nextClean() != '[') {
            throw x2.syntaxError("A JSONArray text must start with '['");
        }
        if (x2.nextClean() != ']') {
            x2.back();
            block4: while (true) {
                if (x2.nextClean() == ',') {
                    x2.back();
                    this.rawList.add(JSONNull.NULL);
                } else {
                    x2.back();
                    this.rawList.add(x2.nextValue());
                }
                switch (x2.nextClean()) {
                    case ',': {
                        if (x2.nextClean() == ']') {
                            return;
                        }
                        x2.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x2.syntaxError("Expected a ',' or ']'");
        }
    }
}

