/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.EscapeUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import cn.hutool.json.XMLTokener;

public class XML {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');

    public static JSONObject toJSONObject(String string) throws JSONException {
        return XML.toJSONObject(string, false);
    }

    public static JSONObject toJSONObject(String string, boolean keepStrings) throws JSONException {
        return XML.toJSONObject(new JSONObject(), string, keepStrings);
    }

    public static JSONObject toJSONObject(JSONObject jo, String string, boolean keepStrings) throws JSONException {
        XMLTokener x2 = new XMLTokener(string, jo.getConfig());
        while (x2.more() && x2.skipPast("<")) {
            XML.parse(x2, jo, null, keepStrings);
        }
        return jo;
    }

    private static boolean parse(XMLTokener x2, JSONObject context, String name, boolean keepStrings) throws JSONException {
        String string;
        Object token = x2.nextToken();
        if (token == BANG) {
            char c2 = x2.next();
            if (c2 == '-') {
                if (x2.next() == '-') {
                    x2.skipPast("-->");
                    return false;
                }
                x2.back();
            } else if (c2 == '[') {
                token = x2.nextToken();
                if ("CDATA".equals(token) && x2.next() == '[') {
                    String string2 = x2.nextCDATA();
                    if (string2.length() > 0) {
                        context.accumulate("content", string2);
                    }
                    return false;
                }
                throw x2.syntaxError("Expected 'CDATA['");
            }
            int i2 = 1;
            do {
                if ((token = x2.nextMeta()) == null) {
                    throw x2.syntaxError("Missing '>' after '<!'.");
                }
                if (token == LT) {
                    ++i2;
                    continue;
                }
                if (token != GT) continue;
                --i2;
            } while (i2 > 0);
            return false;
        }
        if (token == QUEST) {
            x2.skipPast("?>");
            return false;
        }
        if (token == SLASH) {
            token = x2.nextToken();
            if (name == null) {
                throw x2.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(name)) {
                throw x2.syntaxError("Mismatched " + name + " and " + token);
            }
            if (x2.nextToken() != GT) {
                throw x2.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x2.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        JSONObject jsonobject = new JSONObject();
        while (true) {
            if (token == null) {
                token = x2.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = x2.nextToken();
            if (token == EQ) {
                token = x2.nextToken();
                if (!(token instanceof String)) {
                    throw x2.syntaxError("Missing value");
                }
                jsonobject.accumulate(string, keepStrings ? token : InternalJSONUtil.stringToValue((String)token));
                token = null;
                continue;
            }
            jsonobject.accumulate(string, "");
        }
        if (token == SLASH) {
            if (x2.nextToken() != GT) {
                throw x2.syntaxError("Misshaped tag");
            }
            if (jsonobject.size() > 0) {
                context.accumulate(tagName, jsonobject);
            } else {
                context.accumulate(tagName, "");
            }
            return false;
        }
        if (token == GT) {
            while (true) {
                if ((token = x2.nextContent()) == null) {
                    if (tagName != null) {
                        throw x2.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    jsonobject.accumulate("content", keepStrings ? token : InternalJSONUtil.stringToValue(string));
                    continue;
                }
                if (token == LT && XML.parse(x2, jsonobject, tagName, keepStrings)) break;
            }
            if (jsonobject.size() == 0) {
                context.accumulate(tagName, "");
            } else if (jsonobject.size() == 1 && jsonobject.get("content") != null) {
                context.accumulate(tagName, jsonobject.get("content"));
            } else {
                context.accumulate(tagName, jsonobject);
            }
            return false;
        }
        throw x2.syntaxError("Misshaped tag");
    }

    public static String toXml(Object object) throws JSONException {
        return XML.toXml(object, null);
    }

    public static String toXml(Object object, String tagName) throws JSONException {
        if (null == object) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            if (tagName != null) {
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
            }
            JSONObject jo = (JSONObject)object;
            for (String key : jo.keySet()) {
                JSONArray ja;
                Object value = jo.get(key);
                if (value == null) {
                    value = "";
                } else if (ArrayUtil.isArray(value)) {
                    value = new JSONArray(value);
                }
                if ("content".equals(key)) {
                    if (value instanceof JSONArray) {
                        ja = (JSONArray)value;
                        int i2 = 0;
                        for (Object val : ja) {
                            if (i2 > 0) {
                                sb.append('\n');
                            }
                            sb.append(EscapeUtil.escapeHtml4(val.toString()));
                            ++i2;
                        }
                        continue;
                    }
                    sb.append(EscapeUtil.escapeHtml4(value.toString()));
                    continue;
                }
                if (value instanceof JSONArray) {
                    ja = (JSONArray)value;
                    for (Object val : ja) {
                        if (val instanceof JSONArray) {
                            sb.append('<');
                            sb.append(key);
                            sb.append('>');
                            sb.append(XML.toXml(val));
                            sb.append("</");
                            sb.append(key);
                            sb.append('>');
                            continue;
                        }
                        sb.append(XML.toXml(val, key));
                    }
                    continue;
                }
                if ("".equals(value)) {
                    sb.append('<');
                    sb.append(key);
                    sb.append("/>");
                    continue;
                }
                sb.append(XML.toXml(value, key));
            }
            if (tagName != null) {
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
            }
            return sb.toString();
        }
        if (object.getClass().isArray()) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            JSONArray ja = (JSONArray)object;
            for (Object val : ja) {
                sb.append(XML.toXml(val, tagName == null ? "array" : tagName));
            }
            return sb.toString();
        }
        String string = EscapeUtil.escapeHtml4(object.toString());
        return tagName == null ? "\"" + string + "\"" : (string.length() == 0 ? "<" + tagName + "/>" : "<" + tagName + ">" + string + "</" + tagName + ">");
    }
}

