/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.caller.CallerUtil;
import cn.hutool.core.util.ServiceLoaderUtil;
import cn.hutool.log.GlobalLogFactory;
import cn.hutool.log.Log;
import cn.hutool.log.dialect.console.ConsoleLogFactory;
import cn.hutool.log.dialect.jdk.JdkLogFactory;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LogFactory {
    protected String name;
    private final Map<Object, Log> logCache;

    public LogFactory(String name) {
        this.name = name;
        this.logCache = new ConcurrentHashMap<Object, Log>();
    }

    public String getName() {
        return this.name;
    }

    public Log getLog(String name) {
        return this.logCache.computeIfAbsent(name, o2 -> this.createLog((String)o2));
    }

    public Log getLog(Class<?> clazz) {
        return this.logCache.computeIfAbsent(clazz, o2 -> this.createLog((Class)o2));
    }

    public abstract Log createLog(String var1);

    public abstract Log createLog(Class<?> var1);

    protected void checkLogExist(Class<?> logClassName) {
    }

    public static LogFactory getCurrentLogFactory() {
        return GlobalLogFactory.get();
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        return GlobalLogFactory.set(logFactoryClass);
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        return GlobalLogFactory.set(logFactory);
    }

    public static Log get(String name) {
        return LogFactory.getCurrentLogFactory().getLog(name);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.getCurrentLogFactory().getLog(clazz);
    }

    public static Log get() {
        return LogFactory.get(CallerUtil.getCallerCaller());
    }

    public static LogFactory create() {
        LogFactory factory = LogFactory.doCreate();
        factory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", factory.name);
        return factory;
    }

    private static LogFactory doCreate() {
        LogFactory factory = ServiceLoaderUtil.loadFirstAvailable(LogFactory.class);
        if (null != factory) {
            return factory;
        }
        URL url = ResourceUtil.getResource("logging.properties");
        return null != url ? new JdkLogFactory() : new ConsoleLogFactory();
    }
}

