/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.injector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class SqlRunnerInjector {
    private static final Log logger = LogFactory.getLog(SqlRunnerInjector.class);
    protected Configuration configuration;
    protected LanguageDriver languageDriver;

    public void inject(Configuration configuration) {
        this.configuration = configuration;
        this.languageDriver = configuration.getDefaultScriptingLanguageInstance();
        this.initSelectList();
        this.initSelectObjs();
        this.initInsert();
        this.initUpdate();
        this.initDelete();
        this.initCount();
    }

    private boolean hasMappedStatement(String mappedStatement) {
        return this.configuration.hasStatement(mappedStatement, false);
    }

    private void createSelectMappedStatement(String mappedStatement, SqlSource sqlSource, final Class<?> resultType) {
        MappedStatement ms = new MappedStatement.Builder(this.configuration, mappedStatement, sqlSource, SqlCommandType.SELECT).resultMaps((List<ResultMap>)new ArrayList<ResultMap>(){
            {
                this.add(new ResultMap.Builder(SqlRunnerInjector.this.configuration, "defaultResultMap", resultType, new ArrayList<ResultMapping>(0)).build());
            }
        }).build();
        this.configuration.addMappedStatement(ms);
    }

    private void createUpdateMappedStatement(String mappedStatement, SqlSource sqlSource, SqlCommandType sqlCommandType) {
        MappedStatement ms = new MappedStatement.Builder(this.configuration, mappedStatement, sqlSource, sqlCommandType).resultMaps((List<ResultMap>)new ArrayList<ResultMap>(){
            {
                this.add(new ResultMap.Builder(SqlRunnerInjector.this.configuration, "defaultResultMap", Integer.TYPE, new ArrayList<ResultMapping>(0)).build());
            }
        }).build();
        this.configuration.addMappedStatement(ms);
    }

    private void initSelectList() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.SelectList")) {
            logger.warn("MappedStatement 'SqlRunner.SelectList' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createSelectMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.SelectList", sqlSource, Map.class);
    }

    private void initSelectObjs() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.SelectObjs")) {
            logger.warn("MappedStatement 'SqlRunner.SelectObjs' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Object.class);
        this.createSelectMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.SelectObjs", sqlSource, Object.class);
    }

    private void initCount() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.Count")) {
            logger.warn("MappedStatement 'SqlRunner.Count' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createSelectMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.Count", sqlSource, Integer.class);
    }

    private void initInsert() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.Insert")) {
            logger.warn("MappedStatement 'SqlRunner.Insert' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createUpdateMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.Insert", sqlSource, SqlCommandType.INSERT);
    }

    private void initUpdate() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.Update")) {
            logger.warn("MappedStatement 'SqlRunner.Update' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createUpdateMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.Update", sqlSource, SqlCommandType.UPDATE);
    }

    private void initDelete() {
        if (this.hasMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.Delete")) {
            logger.warn("MappedStatement 'SqlRunner.Delete' Already Exists");
            return;
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, "${sql}", Map.class);
        this.createUpdateMappedStatement("com.baomidou.mybatisplus.core.mapper.SqlRunner.Delete", sqlSource, SqlCommandType.DELETE);
    }
}

