/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.parser;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.MetaObject;

public abstract class AbstractJsqlParser
implements ISqlParser {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public SqlInfo parser(MetaObject metaObject, String sql) {
        if (this.allowProcess(metaObject)) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Original SQL: " + sql);
                }
                StringBuilder sqlStringBuilder = new StringBuilder();
                Statements statements = CCJSqlParserUtil.parseStatements(sql);
                int i2 = 0;
                for (Statement statement : statements.getStatements()) {
                    if (null == statement) continue;
                    if (i2++ > 0) {
                        sqlStringBuilder.append(';');
                    }
                    sqlStringBuilder.append(this.processParser(statement).getSql());
                }
                if (sqlStringBuilder.length() > 0) {
                    return SqlInfo.newInstance().setSql(sqlStringBuilder.toString());
                }
            }
            catch (JSQLParserException e2) {
                throw ExceptionUtils.mpe("Failed to process, please exclude the tableName or statementId.\n Error SQL: %s", e2, sql);
            }
        }
        return null;
    }

    public SqlInfo processParser(Statement statement) {
        if (statement instanceof Insert) {
            this.processInsert((Insert)statement);
        } else if (statement instanceof Select) {
            this.processSelectBody(((Select)statement).getSelectBody());
        } else if (statement instanceof Update) {
            this.processUpdate((Update)statement);
        } else if (statement instanceof Delete) {
            this.processDelete((Delete)statement);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("parser sql: " + statement.toString());
        }
        return SqlInfo.newInstance().setSql(statement.toString());
    }

    public abstract void processInsert(Insert var1);

    public abstract void processDelete(Delete var1);

    public abstract void processUpdate(Update var1);

    public abstract void processSelectBody(SelectBody var1);

    public boolean allowProcess(MetaObject metaObject) {
        return true;
    }
}

