/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class LambdaUtils {
    private static final Map<String, Map<String, ColumnCache>> COLUMN_CACHE_MAP = new ConcurrentHashMap<String, Map<String, ColumnCache>>();
    private static final Map<String, WeakReference<SerializedLambda>> FUNC_CACHE = new ConcurrentHashMap<String, WeakReference<SerializedLambda>>();

    public static <T> SerializedLambda resolve(SFunction<T, ?> func) {
        Class<?> clazz = func.getClass();
        String name = clazz.getName();
        return Optional.ofNullable(FUNC_CACHE.get(name)).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = SerializedLambda.resolve(func);
            FUNC_CACHE.put(name, new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }

    public static String formatKey(String key) {
        return key.toUpperCase(Locale.ENGLISH);
    }

    public static void installCache(TableInfo tableInfo) {
        COLUMN_CACHE_MAP.put(tableInfo.getEntityType().getName(), LambdaUtils.createColumnCacheMap(tableInfo));
    }

    private static Map<String, ColumnCache> createColumnCacheMap(TableInfo info) {
        HashMap<String, ColumnCache> map;
        if (info.havePK()) {
            map = CollectionUtils.newHashMapWithExpectedSize(info.getFieldList().size() + 1);
            map.put(LambdaUtils.formatKey(info.getKeyProperty()), new ColumnCache(info.getKeyColumn(), info.getKeySqlSelect()));
        } else {
            map = CollectionUtils.newHashMapWithExpectedSize(info.getFieldList().size());
        }
        info.getFieldList().forEach(i2 -> map.put(LambdaUtils.formatKey(i2.getProperty()), new ColumnCache(i2.getColumn(), i2.getSqlSelect())));
        return map;
    }

    public static Map<String, ColumnCache> getColumnMap(Class<?> clazz) {
        return CollectionUtils.computeIfAbsent(COLUMN_CACHE_MAP, clazz.getName(), key -> {
            TableInfo info = TableInfoHelper.getTableInfo(clazz);
            return info == null ? null : LambdaUtils.createColumnCacheMap(info);
        });
    }
}

