/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public final class ReflectionKit {
    private static final Log logger = LogFactory.getLog(ReflectionKit.class);
    private static final Map<Class<?>, List<Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP = new IdentityHashMap(8);

    @Deprecated
    public static String setMethodCapitalize(Field field, String str) {
        return StringUtils.concatCapitalize("set", str);
    }

    public static Object getFieldValue(Object entity, String fieldName) {
        Class<?> cls = entity.getClass();
        Map<String, Field> fieldMaps = ReflectionKit.getFieldMap(cls);
        try {
            Field field = fieldMaps.get(fieldName);
            Assert.notNull(field, "Error: NoSuchField in %s for %s.  Cause:", cls.getSimpleName(), fieldName);
            field.setAccessible(true);
            return field.get(entity);
        }
        catch (ReflectiveOperationException e2) {
            throw ExceptionUtils.mpe("Error: Cannot read field in %s.  Cause:", e2, cls.getSimpleName());
        }
    }

    public static Class<?> getSuperClassGenericType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(String.format("Warn: %s's superclass not ParameterizedType", clazz.getSimpleName()));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn(String.format("Warn: Index: %s, Size of %s's Parameterized Type: %s .", index, clazz.getSimpleName(), params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(String.format("Warn: %s not set the actual class on superclass generic parameter", clazz.getSimpleName()));
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        List<Field> fieldList = ReflectionKit.getFieldList(clazz);
        return CollectionUtils.isNotEmpty(fieldList) ? fieldList.stream().collect(Collectors.toMap(Field::getName, field -> field)) : Collections.emptyMap();
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return Collections.emptyList();
        }
        return CollectionUtils.computeIfAbsent(CLASS_FIELD_CACHE, clazz, k2 -> {
            Field[] fields = k2.getDeclaredFields();
            ArrayList<Field> superFields = new ArrayList<Field>();
            for (Class currentClass = k2.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] declaredFields = currentClass.getDeclaredFields();
                Collections.addAll(superFields, declaredFields);
            }
            Map<String, Field> fieldMap = ReflectionKit.excludeOverrideSuperField(fields, superFields);
            return fieldMap.values().stream().filter(f2 -> !Modifier.isStatic(f2.getModifiers())).filter(f2 -> !Modifier.isTransient(f2.getModifiers())).collect(Collectors.toList());
        });
    }

    @Deprecated
    public static List<Field> doGetFieldList(Class<?> clazz) {
        if (clazz.getSuperclass() != null) {
            Map<String, Field> fieldMap = ReflectionKit.excludeOverrideSuperField(clazz.getDeclaredFields(), ReflectionKit.getFieldList(clazz.getSuperclass()));
            return fieldMap.values().stream().filter(f2 -> !Modifier.isStatic(f2.getModifiers())).filter(f2 -> !Modifier.isTransient(f2.getModifiers())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static Map<String, Field> excludeOverrideSuperField(Field[] fields, List<Field> superFieldList) {
        Map fieldMap = Stream.of(fields).collect(Collectors.toMap(Field::getName, Function.identity(), (u2, v2) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u2));
        }, LinkedHashMap::new));
        superFieldList.stream().filter(field -> !fieldMap.containsKey(field.getName())).forEach(f2 -> fieldMap.put(f2.getName(), f2));
        return fieldMap;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null", new Object[0]);
        return clazz.isPrimitive() || PRIMITIVE_WRAPPER_TYPE_MAP.containsKey(clazz);
    }

    static {
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
    }
}

