/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.handlers;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.util.List;
import org.apache.ibatis.executor.statement.CallableStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

public abstract class AbstractSqlParserHandler {
    private List<ISqlParser> sqlParserList;
    private ISqlParserFilter sqlParserFilter;

    protected void sqlParser(MetaObject metaObject) {
        if (null != metaObject) {
            Object originalObject = metaObject.getOriginalObject();
            StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget(originalObject);
            metaObject = SystemMetaObject.forObject(statementHandler);
            if (null != this.sqlParserFilter && this.sqlParserFilter.doFilter(metaObject)) {
                return;
            }
            if (SqlParserHelper.getSqlParserInfo(metaObject)) {
                return;
            }
            if (CollectionUtils.isNotEmpty(this.sqlParserList)) {
                StatementHandler statementHandler2 = statementHandler = metaObject.hasGetter("delegate") ? (StatementHandler)metaObject.getValue("delegate") : statementHandler;
                if (!(statementHandler instanceof CallableStatementHandler)) {
                    boolean sqlChangedFlag = false;
                    String originalSql = (String)metaObject.getValue("delegate.boundSql.sql");
                    for (ISqlParser sqlParser : this.sqlParserList) {
                        SqlInfo sqlInfo;
                        if (!sqlParser.doFilter(metaObject, originalSql) || null == (sqlInfo = sqlParser.parser(metaObject, originalSql))) continue;
                        originalSql = sqlInfo.getSql();
                        sqlChangedFlag = true;
                    }
                    if (sqlChangedFlag) {
                        metaObject.setValue("delegate.boundSql.sql", originalSql);
                    }
                }
            }
        }
    }

    public List<ISqlParser> getSqlParserList() {
        return this.sqlParserList;
    }

    public ISqlParserFilter getSqlParserFilter() {
        return this.sqlParserFilter;
    }

    public AbstractSqlParserHandler setSqlParserList(List<ISqlParser> sqlParserList) {
        this.sqlParserList = sqlParserList;
        return this;
    }

    public AbstractSqlParserHandler setSqlParserFilter(ISqlParserFilter sqlParserFilter) {
        this.sqlParserFilter = sqlParserFilter;
        return this;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AbstractSqlParserHandler)) {
            return false;
        }
        AbstractSqlParserHandler other = (AbstractSqlParserHandler)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ISqlParser> this$sqlParserList = this.getSqlParserList();
        List<ISqlParser> other$sqlParserList = other.getSqlParserList();
        if (this$sqlParserList == null ? other$sqlParserList != null : !((Object)this$sqlParserList).equals(other$sqlParserList)) {
            return false;
        }
        ISqlParserFilter this$sqlParserFilter = this.getSqlParserFilter();
        ISqlParserFilter other$sqlParserFilter = other.getSqlParserFilter();
        return !(this$sqlParserFilter == null ? other$sqlParserFilter != null : !this$sqlParserFilter.equals(other$sqlParserFilter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSqlParserHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ISqlParser> $sqlParserList = this.getSqlParserList();
        result = result * 59 + ($sqlParserList == null ? 43 : ((Object)$sqlParserList).hashCode());
        ISqlParserFilter $sqlParserFilter = this.getSqlParserFilter();
        result = result * 59 + ($sqlParserFilter == null ? 43 : $sqlParserFilter.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractSqlParserHandler(sqlParserList=" + this.getSqlParserList() + ", sqlParserFilter=" + this.getSqlParserFilter() + ")";
    }
}

