/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;

public class DialectModel {
    private static final String FIRST_PARAM_NAME = "mybatis_plus_first";
    private static final String SECOND_PARAM_NAME = "mybatis_plus_second";
    private final String dialectSql;
    private Configuration configuration;
    private Consumer<List<ParameterMapping>> firstParamConsumer = i2 -> {};
    private Consumer<Map<String, Object>> firstParamMapConsumer = i2 -> {};
    private Consumer<List<ParameterMapping>> secondParamConsumer = i2 -> {};
    private Consumer<Map<String, Object>> secondParamMapConsumer = i2 -> {};
    private final long firstParam;
    private final long secondParam;

    public DialectModel(String dialectSql) {
        this(dialectSql, 0L, 0L);
    }

    public DialectModel(String dialectSql, long firstParam) {
        this(dialectSql, firstParam, 0L);
    }

    public DialectModel(String dialectSql, long firstParam, long secondParam) {
        this.dialectSql = dialectSql;
        this.firstParam = firstParam;
        this.secondParam = secondParam;
    }

    public DialectModel setConsumer(boolean isFirstParam, Function<List<ParameterMapping>, Integer> function) {
        if (isFirstParam) {
            this.firstParamConsumer = i2 -> i2.add((Integer)function.apply((List<ParameterMapping>)i2), new ParameterMapping.Builder(this.configuration, FIRST_PARAM_NAME, Long.TYPE).build());
        } else {
            this.secondParamConsumer = i2 -> i2.add((Integer)function.apply((List<ParameterMapping>)i2), new ParameterMapping.Builder(this.configuration, SECOND_PARAM_NAME, Long.TYPE).build());
        }
        this.setParamMapConsumer(isFirstParam);
        return this;
    }

    public DialectModel setConsumer(boolean isFirstParam) {
        if (isFirstParam) {
            this.firstParamConsumer = i2 -> i2.add(new ParameterMapping.Builder(this.configuration, FIRST_PARAM_NAME, Long.TYPE).build());
        } else {
            this.secondParamConsumer = i2 -> i2.add(new ParameterMapping.Builder(this.configuration, SECOND_PARAM_NAME, Long.TYPE).build());
        }
        this.setParamMapConsumer(isFirstParam);
        return this;
    }

    public DialectModel setConsumerChain() {
        return this.setConsumer(true).setConsumer(false);
    }

    public void consumers(List<ParameterMapping> parameterMappings, Configuration configuration, Map<String, Object> additionalParameters) {
        Assert.notNull(configuration, "configuration must notNull !", new Object[0]);
        Assert.notNull(parameterMappings, "parameterMappings must notNull !", new Object[0]);
        Assert.notNull(additionalParameters, "additionalParameters must notNull !", new Object[0]);
        this.configuration = configuration;
        this.firstParamConsumer.accept(parameterMappings);
        this.secondParamConsumer.accept(parameterMappings);
        this.firstParamMapConsumer.accept(additionalParameters);
        this.secondParamMapConsumer.accept(additionalParameters);
    }

    private void setParamMapConsumer(boolean isFirstParam) {
        if (isFirstParam) {
            this.firstParamMapConsumer = i2 -> i2.put(FIRST_PARAM_NAME, this.firstParam);
        } else {
            this.secondParamMapConsumer = i2 -> i2.put(SECOND_PARAM_NAME, this.secondParam);
        }
    }

    public String getDialectSql() {
        return this.dialectSql;
    }
}

