/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.TypeConverts;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import java.util.function.Function;

public class SqlServerTypeConvert
implements ITypeConvert {
    public static final SqlServerTypeConvert INSTANCE = new SqlServerTypeConvert();

    @Override
    public IColumnType processTypeConvert(GlobalConfig config, String fieldType) {
        return TypeConverts.use(fieldType).test(TypeConverts.containsAny("char", "xml", "text").then(DbColumnType.STRING)).test(TypeConverts.contains("bigint").then(DbColumnType.LONG)).test(TypeConverts.contains("int").then(DbColumnType.INTEGER)).test(TypeConverts.containsAny("date", "time").then((IColumnType)((Object)((Function<String, IColumnType>)t2 -> SqlServerTypeConvert.toDateType(config, t2))))).test(TypeConverts.contains("bit").then(DbColumnType.BOOLEAN)).test(TypeConverts.containsAny("decimal", "numeric").then(DbColumnType.DOUBLE)).test(TypeConverts.contains("money").then(DbColumnType.BIG_DECIMAL)).test(TypeConverts.containsAny("binary", "image").then(DbColumnType.BYTE_ARRAY)).test(TypeConverts.containsAny("float", "real").then(DbColumnType.FLOAT)).or(DbColumnType.STRING);
    }

    public static IColumnType toDateType(GlobalConfig config, String type) {
        switch (config.getDateType()) {
            case SQL_PACK: {
                switch (type) {
                    case "date": {
                        return DbColumnType.DATE_SQL;
                    }
                    case "time": {
                        return DbColumnType.TIME;
                    }
                }
                return DbColumnType.TIMESTAMP;
            }
            case TIME_PACK: {
                switch (type) {
                    case "date": {
                        return DbColumnType.LOCAL_DATE;
                    }
                    case "time": {
                        return DbColumnType.LOCAL_TIME;
                    }
                }
                return DbColumnType.LOCAL_DATE_TIME;
            }
        }
        return DbColumnType.DATE;
    }
}

