/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.po;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;

public class TableInfo {
    private final Set<String> importPackages = new HashSet<String>();
    private boolean convert;
    private String name;
    private String comment;
    private String entityName;
    private String mapperName;
    private String xmlName;
    private String serviceName;
    private String serviceImplName;
    private String controllerName;
    private List<TableField> fields;
    private boolean havePrimaryKey;
    private List<TableField> commonFields;
    private String fieldNames;

    public TableInfo setConvert(boolean convert) {
        this.convert = convert;
        return this;
    }

    protected TableInfo setConvert(StrategyConfig strategyConfig) {
        if (strategyConfig.startsWithTablePrefix(this.name) || strategyConfig.isEntityTableFieldAnnotationEnable()) {
            this.convert = true;
        } else if (strategyConfig.isCapitalModeNaming(this.name)) {
            this.convert = false;
        } else if (NamingStrategy.underline_to_camel == strategyConfig.getColumnNaming()) {
            if (StringUtils.containsUpperCase(this.name)) {
                this.convert = true;
            }
        } else if (!this.entityName.equalsIgnoreCase(this.name)) {
            this.convert = true;
        }
        return this;
    }

    public String getEntityPath() {
        return this.entityName.substring(0, 1).toLowerCase() + this.entityName.substring(1);
    }

    public TableInfo setEntityName(StrategyConfig strategyConfig, String entityName) {
        this.entityName = entityName;
        this.setConvert(strategyConfig);
        return this;
    }

    public TableInfo setFields(List<TableField> fields) {
        this.fields = fields;
        if (CollectionUtils.isNotEmpty(fields)) {
            for (TableField field : fields) {
                if (null != field.getColumnType() && null != field.getColumnType().getPkg()) {
                    this.importPackages.add(field.getColumnType().getPkg());
                }
                if (field.isKeyFlag()) {
                    if (field.isConvert() || field.isKeyIdentityFlag()) {
                        this.importPackages.add(TableId.class.getCanonicalName());
                    }
                    if (field.isKeyIdentityFlag()) {
                        this.importPackages.add(IdType.class.getCanonicalName());
                    }
                } else if (field.isConvert()) {
                    this.importPackages.add(com.baomidou.mybatisplus.annotation.TableField.class.getCanonicalName());
                }
                if (null == field.getFill()) continue;
                this.importPackages.add(com.baomidou.mybatisplus.annotation.TableField.class.getCanonicalName());
                this.importPackages.add(FieldFill.class.getCanonicalName());
            }
        }
        return this;
    }

    public TableInfo setImportPackages(String pkg) {
        if (this.importPackages.contains(pkg)) {
            return this;
        }
        this.importPackages.add(pkg);
        return this;
    }

    public boolean isLogicDelete(String logicDeletePropertyName) {
        return this.fields.parallelStream().anyMatch(tf -> tf.getName().equals(logicDeletePropertyName));
    }

    public String getFieldNames() {
        if (StringUtils.isBlank(this.fieldNames) && CollectionUtils.isNotEmpty(this.fields)) {
            StringBuilder names = new StringBuilder();
            IntStream.range(0, this.fields.size()).forEach(i2 -> {
                TableField fd = this.fields.get(i2);
                if (i2 == this.fields.size() - 1) {
                    names.append(fd.getColumnName());
                } else {
                    names.append(fd.getColumnName()).append(", ");
                }
            });
            this.fieldNames = names.toString();
        }
        return this.fieldNames;
    }

    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public boolean isConvert() {
        return this.convert;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceImplName() {
        return this.serviceImplName;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public List<TableField> getFields() {
        return this.fields;
    }

    public boolean isHavePrimaryKey() {
        return this.havePrimaryKey;
    }

    public List<TableField> getCommonFields() {
        return this.commonFields;
    }

    public TableInfo setName(String name) {
        this.name = name;
        return this;
    }

    public TableInfo setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public TableInfo setEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public TableInfo setMapperName(String mapperName) {
        this.mapperName = mapperName;
        return this;
    }

    public TableInfo setXmlName(String xmlName) {
        this.xmlName = xmlName;
        return this;
    }

    public TableInfo setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public TableInfo setServiceImplName(String serviceImplName) {
        this.serviceImplName = serviceImplName;
        return this;
    }

    public TableInfo setControllerName(String controllerName) {
        this.controllerName = controllerName;
        return this;
    }

    public TableInfo setHavePrimaryKey(boolean havePrimaryKey) {
        this.havePrimaryKey = havePrimaryKey;
        return this;
    }

    public TableInfo setCommonFields(List<TableField> commonFields) {
        this.commonFields = commonFields;
        return this;
    }

    public TableInfo setFieldNames(String fieldNames) {
        this.fieldNames = fieldNames;
        return this;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof TableInfo)) {
            return false;
        }
        TableInfo other = (TableInfo)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isConvert() != other.isConvert()) {
            return false;
        }
        if (this.isHavePrimaryKey() != other.isHavePrimaryKey()) {
            return false;
        }
        Set<String> this$importPackages = this.getImportPackages();
        Set<String> other$importPackages = other.getImportPackages();
        if (this$importPackages == null ? other$importPackages != null : !((Object)this$importPackages).equals(other$importPackages)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        String this$mapperName = this.getMapperName();
        String other$mapperName = other.getMapperName();
        if (this$mapperName == null ? other$mapperName != null : !this$mapperName.equals(other$mapperName)) {
            return false;
        }
        String this$xmlName = this.getXmlName();
        String other$xmlName = other.getXmlName();
        if (this$xmlName == null ? other$xmlName != null : !this$xmlName.equals(other$xmlName)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$serviceImplName = this.getServiceImplName();
        String other$serviceImplName = other.getServiceImplName();
        if (this$serviceImplName == null ? other$serviceImplName != null : !this$serviceImplName.equals(other$serviceImplName)) {
            return false;
        }
        String this$controllerName = this.getControllerName();
        String other$controllerName = other.getControllerName();
        if (this$controllerName == null ? other$controllerName != null : !this$controllerName.equals(other$controllerName)) {
            return false;
        }
        List<TableField> this$fields = this.getFields();
        List<TableField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List<TableField> this$commonFields = this.getCommonFields();
        List<TableField> other$commonFields = other.getCommonFields();
        if (this$commonFields == null ? other$commonFields != null : !((Object)this$commonFields).equals(other$commonFields)) {
            return false;
        }
        String this$fieldNames = this.getFieldNames();
        String other$fieldNames = other.getFieldNames();
        return !(this$fieldNames == null ? other$fieldNames != null : !this$fieldNames.equals(other$fieldNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConvert() ? 79 : 97);
        result = result * 59 + (this.isHavePrimaryKey() ? 79 : 97);
        Set<String> $importPackages = this.getImportPackages();
        result = result * 59 + ($importPackages == null ? 43 : ((Object)$importPackages).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        String $mapperName = this.getMapperName();
        result = result * 59 + ($mapperName == null ? 43 : $mapperName.hashCode());
        String $xmlName = this.getXmlName();
        result = result * 59 + ($xmlName == null ? 43 : $xmlName.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $serviceImplName = this.getServiceImplName();
        result = result * 59 + ($serviceImplName == null ? 43 : $serviceImplName.hashCode());
        String $controllerName = this.getControllerName();
        result = result * 59 + ($controllerName == null ? 43 : $controllerName.hashCode());
        List<TableField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List<TableField> $commonFields = this.getCommonFields();
        result = result * 59 + ($commonFields == null ? 43 : ((Object)$commonFields).hashCode());
        String $fieldNames = this.getFieldNames();
        result = result * 59 + ($fieldNames == null ? 43 : $fieldNames.hashCode());
        return result;
    }

    public String toString() {
        return "TableInfo(importPackages=" + this.getImportPackages() + ", convert=" + this.isConvert() + ", name=" + this.getName() + ", comment=" + this.getComment() + ", entityName=" + this.getEntityName() + ", mapperName=" + this.getMapperName() + ", xmlName=" + this.getXmlName() + ", serviceName=" + this.getServiceName() + ", serviceImplName=" + this.getServiceImplName() + ", controllerName=" + this.getControllerName() + ", fields=" + this.getFields() + ", havePrimaryKey=" + this.isHavePrimaryKey() + ", commonFields=" + this.getCommonFields() + ", fieldNames=" + this.getFieldNames() + ")";
    }
}

